"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppProviders = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("../../common");
var _shared_imports = require("../shared_imports");
var _app_context = require("./app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppProviders = ({
  appDependencies,
  children
}) => {
  const {
    core,
    theme$
  } = appDependencies;
  const {
    i18n: {
      Context: I18nContext
    },
    http
  } = core;
  return /*#__PURE__*/_react.default.createElement(_shared_imports.AuthorizationProvider, {
    httpClient: http,
    privilegesEndpoint: `${_common.API_BASE_PATH}privileges`
  }, /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: appDependencies
  }, children))));
};
exports.AppProviders = AppProviders;