"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSLOResponseSchema = exports.updateSLOParamsSchema = exports.sloWithSummaryResponseSchema = exports.sloResponseSchema = exports.manageSLOParamsSchema = exports.getSLOResponseSchema = exports.getSLOParamsSchema = exports.getSLODiagnosisParamsSchema = exports.findSLOResponseSchema = exports.findSLOParamsSchema = exports.fetchHistoricalSummaryResponseSchema = exports.fetchHistoricalSummaryParamsSchema = exports.deleteSLOParamsSchema = exports.createSLOParamsSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _schema = require("../schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createSLOParamsSchema = t.type({
  body: t.intersection([t.type({
    name: t.string,
    description: t.string,
    indicator: _schema.indicatorSchema,
    timeWindow: _schema.timeWindowSchema,
    budgetingMethod: _schema.budgetingMethodSchema,
    objective: _schema.objectiveSchema
  }), t.partial({
    settings: _schema.optionalSettingsSchema,
    tags: _schema.tagsSchema
  })])
});
exports.createSLOParamsSchema = createSLOParamsSchema;
const createSLOResponseSchema = t.type({
  id: _schema.sloIdSchema
});
const deleteSLOParamsSchema = t.type({
  path: t.type({
    id: _schema.sloIdSchema
  })
});
exports.deleteSLOParamsSchema = deleteSLOParamsSchema;
const getSLOParamsSchema = t.type({
  path: t.type({
    id: _schema.sloIdSchema
  })
});
exports.getSLOParamsSchema = getSLOParamsSchema;
const sortDirectionSchema = t.union([t.literal('asc'), t.literal('desc')]);
const sortBySchema = t.union([t.literal('creationTime'), t.literal('indicatorType')]);
const findSLOParamsSchema = t.partial({
  query: t.partial({
    name: t.string,
    indicatorTypes: _schema.indicatorTypesArraySchema,
    page: t.string,
    perPage: t.string,
    sortBy: sortBySchema,
    sortDirection: sortDirectionSchema
  })
});
exports.findSLOParamsSchema = findSLOParamsSchema;
const sloResponseSchema = t.type({
  id: _schema.sloIdSchema,
  name: t.string,
  description: t.string,
  indicator: _schema.indicatorSchema,
  timeWindow: _schema.timeWindowSchema,
  budgetingMethod: _schema.budgetingMethodSchema,
  objective: _schema.objectiveSchema,
  revision: t.number,
  settings: _schema.settingsSchema,
  enabled: t.boolean,
  tags: _schema.tagsSchema,
  createdAt: _schema.dateType,
  updatedAt: _schema.dateType
});
exports.sloResponseSchema = sloResponseSchema;
const sloWithSummaryResponseSchema = t.intersection([sloResponseSchema, t.type({
  summary: _schema.summarySchema
})]);
exports.sloWithSummaryResponseSchema = sloWithSummaryResponseSchema;
const getSLOResponseSchema = sloWithSummaryResponseSchema;
exports.getSLOResponseSchema = getSLOResponseSchema;
const updateSLOParamsSchema = t.type({
  path: t.type({
    id: _schema.sloIdSchema
  }),
  body: t.partial({
    name: t.string,
    description: t.string,
    indicator: _schema.indicatorSchema,
    timeWindow: _schema.timeWindowSchema,
    budgetingMethod: _schema.budgetingMethodSchema,
    objective: _schema.objectiveSchema,
    settings: _schema.optionalSettingsSchema,
    tags: _schema.tagsSchema
  })
});
exports.updateSLOParamsSchema = updateSLOParamsSchema;
const manageSLOParamsSchema = t.type({
  path: t.type({
    id: _schema.sloIdSchema
  })
});
exports.manageSLOParamsSchema = manageSLOParamsSchema;
const updateSLOResponseSchema = sloResponseSchema;
exports.updateSLOResponseSchema = updateSLOResponseSchema;
const findSLOResponseSchema = t.type({
  page: t.number,
  perPage: t.number,
  total: t.number,
  results: t.array(sloWithSummaryResponseSchema)
});
exports.findSLOResponseSchema = findSLOResponseSchema;
const fetchHistoricalSummaryParamsSchema = t.type({
  body: t.type({
    sloIds: t.array(_schema.sloIdSchema)
  })
});
exports.fetchHistoricalSummaryParamsSchema = fetchHistoricalSummaryParamsSchema;
const fetchHistoricalSummaryResponseSchema = t.record(_schema.sloIdSchema, t.array(_schema.historicalSummarySchema));
exports.fetchHistoricalSummaryResponseSchema = fetchHistoricalSummaryResponseSchema;
const getSLODiagnosisParamsSchema = t.type({
  path: t.type({
    id: t.string
  })
});
exports.getSLODiagnosisParamsSchema = getSLODiagnosisParamsSchema;