"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _common = require("@kbn/kibana-utils-plugin/common");
var _redirect = require("../../../common/url_service/locators/redirect");
var _legacy_short_url_locator = require("../../../common/url_service/locators/legacy_short_url_locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class RedirectManager {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "error$", new _rxjs.BehaviorSubject(null));
    this.deps = deps;
  }
  registerLocatorRedirectApp(core) {
    core.application.register({
      id: 'r',
      title: 'Redirect endpoint',
      chromeless: true,
      mount: async params => {
        const {
          render
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./render')));
        const unmount = render(params.element, {
          manager: this,
          theme: core.theme,
          customBranding: core.customBranding
        });
        this.onMount(params.history.location);
        return () => {
          unmount();
        };
      }
    });
  }
  registerLegacyShortUrlRedirectApp(core) {
    core.application.register({
      id: 'short_url_redirect',
      appRoute: '/goto',
      title: 'Short URL Redirect',
      chromeless: true,
      mount: async () => {
        var _location$pathname$ma;
        const urlId = (_location$pathname$ma = location.pathname.match(new RegExp(`/goto/(.*)$`))) === null || _location$pathname$ma === void 0 ? void 0 : _location$pathname$ma[1];
        if (!urlId) throw new Error('Url id not present in path');
        const urlService = this.deps.url;
        const shortUrls = urlService.shortUrls.get(null);
        const shortUrl = await shortUrls.get(urlId);
        const locatorId = shortUrl.data.locator.id;
        const locator = urlService.locators.get(locatorId);
        if (!locator) throw new Error(`Locator [id = ${locatorId}] not found.`);
        const locatorState = shortUrl.data.locator.state;
        if (shortUrl.data.locator.id !== _legacy_short_url_locator.LEGACY_SHORT_URL_LOCATOR_ID) {
          await locator.navigate(locatorState, {
            replace: true
          });
          return () => {};
        }
        let redirectUrl = locatorState.url;
        const storeInSessionStorage = core.uiSettings.get('state:storeInSessionStorage');
        if (storeInSessionStorage) {
          const {
            hashUrl
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/kibana-utils-plugin/public')));
          redirectUrl = hashUrl(redirectUrl);
        }
        const url = core.http.basePath.prepend(redirectUrl);
        location.href = url;
        return () => {};
      }
    });
  }
  onMount(location) {
    const pathname = location.pathname;
    const isShortUrlRedirectBySlug = pathname.startsWith('/s/');
    if (isShortUrlRedirectBySlug) {
      this.navigateToShortUrlBySlug(pathname.substring('/s/'.length));
      return;
    }
    const urlLocationSearch = location.search;
    const options = this.parseSearchParams(urlLocationSearch);
    this.navigate(options);
  }
  navigateToShortUrlBySlug(slug) {
    (async () => {
      const urlService = this.deps.url;
      const shortUrls = urlService.shortUrls.get(null);
      const shortUrl = await shortUrls.resolve(slug);
      const locatorId = shortUrl.data.locator.id;
      const locator = urlService.locators.get(locatorId);
      if (!locator) throw new Error(`Locator "${locatorId}" not found.`);
      const locatorState = shortUrl.data.locator.state;
      await locator.navigate(locatorState, {
        replace: true
      });
    })().catch(error => {
      this.error$.next(error);
      // eslint-disable-next-line no-console
      console.error(error);
    });
  }
  navigate(options) {
    const locator = this.deps.url.locators.get(options.id);
    if (!locator) {
      const message = _i18n.i18n.translate('share.urlService.redirect.RedirectManager.locatorNotFound', {
        defaultMessage: 'Locator [ID = {id}] does not exist.',
        values: {
          id: options.id
        },
        description: 'Error displayed to user in redirect endpoint when redirection cannot be performed successfully, because locator does not exist.'
      });
      const error = new Error(message);
      this.error$.next(error);
      throw error;
    }
    const locatorMigrations = typeof locator.migrations === 'function' ? locator.migrations() : locator.migrations;
    const migratedParams = (0, _common.migrateToLatest)(locatorMigrations, {
      state: options.params,
      version: options.version
    });
    locator.navigate(migratedParams, {
      replace: true // We do not want the redirect app URL to appear in browser navigation history
    }).then().catch(error => {
      // eslint-disable-next-line no-console
      console.log('Redirect endpoint failed to execute locator redirect.');
      // eslint-disable-next-line no-console
      console.error(error);
    });
  }
  parseSearchParams(urlLocationSearch) {
    try {
      return (0, _redirect.parseSearchParams)(urlLocationSearch);
    } catch (error) {
      this.error$.next(error);
      throw error;
    }
  }
}
exports.RedirectManager = RedirectManager;