"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareMenuManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _share_context_menu = require("../components/share_context_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ShareMenuManager {
  constructor() {
    (0, _defineProperty2.default)(this, "isOpen", false);
    (0, _defineProperty2.default)(this, "container", document.createElement('div'));
    (0, _defineProperty2.default)(this, "onClose", () => {
      _reactDom.default.unmountComponentAtNode(this.container);
      this.isOpen = false;
    });
  }
  start(core, urlService, shareRegistry, anonymousAccessServiceProvider) {
    return {
      /**
       * Collects share menu items from registered providers and mounts the share context menu under
       * the given `anchorElement`. If the context menu is already opened, a call to this method closes it.
       * @param options
       */
      toggleShareContextMenu: options => {
        const onClose = () => {
          var _options$onClose;
          this.onClose();
          (_options$onClose = options.onClose) === null || _options$onClose === void 0 ? void 0 : _options$onClose.call(options);
        };
        const menuItems = shareRegistry.getShareMenuItems({
          ...options,
          onClose
        });
        const anonymousAccess = anonymousAccessServiceProvider === null || anonymousAccessServiceProvider === void 0 ? void 0 : anonymousAccessServiceProvider();
        this.toggleShareContextMenu({
          ...options,
          onClose,
          menuItems,
          urlService,
          anonymousAccess,
          theme: core.theme
        });
      }
    };
  }
  toggleShareContextMenu({
    anchorElement,
    allowEmbed,
    allowShortUrl,
    objectId,
    objectType,
    sharingData,
    menuItems,
    shareableUrl,
    shareableUrlForSavedObject,
    embedUrlParamExtensions,
    theme,
    showPublicUrlSwitch,
    urlService,
    anonymousAccess,
    snapshotShareWarning,
    onClose,
    objectTypeTitle,
    disabledShareUrl
  }) {
    if (this.isOpen) {
      onClose();
      return;
    }
    this.isOpen = true;
    document.body.appendChild(this.container);
    const element = /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
      id: "sharePopover",
      button: anchorElement,
      isOpen: true,
      closePopover: onClose,
      panelPaddingSize: "none",
      anchorPosition: "downLeft"
    }, /*#__PURE__*/_react.default.createElement(_share_context_menu.ShareContextMenu, {
      allowEmbed: allowEmbed,
      allowShortUrl: allowShortUrl,
      objectId: objectId,
      objectType: objectType,
      objectTypeTitle: objectTypeTitle,
      shareMenuItems: menuItems,
      sharingData: sharingData,
      shareableUrl: shareableUrl,
      shareableUrlForSavedObject: shareableUrlForSavedObject,
      onClose: onClose,
      embedUrlParamExtensions: embedUrlParamExtensions,
      anonymousAccess: anonymousAccess,
      showPublicUrlSwitch: showPublicUrlSwitch,
      urlService: urlService,
      snapshotShareWarning: snapshotShareWarning,
      disabledShareUrl: disabledShareUrl
    }))));
    _reactDom.default.render(element, this.container);
  }
}
exports.ShareMenuManager = ShareMenuManager;