"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionViewDetailPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _helpers = require("./helpers");
var _detail_panel_process_tab = require("../detail_panel_process_tab");
var _detail_panel_metadata_tab = require("../detail_panel_metadata_tab");
var _styles = require("./styles");
var _detail_panel_alert_tab = require("../detail_panel_alert_tab");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Detail panel in the session view.
 */
const SessionViewDetailPanel = ({
  alerts,
  alertsCount,
  isFetchingAlerts,
  hasNextPageAlerts,
  fetchNextPageAlerts,
  selectedProcess,
  investigatedAlertId,
  onJumpToEvent,
  onShowAlertDetails
}) => {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)('process');
  const alertsCountStr = (0, _react.useMemo)(() => {
    return alertsCount >= _constants.ALERT_COUNT_THRESHOLD ? _constants.ALERT_COUNT_THRESHOLD + '+' : alertsCount + '';
  }, [alertsCount]);
  const tabs = (0, _react.useMemo)(() => {
    var _selectedProcess$getD, _selectedProcess$getD2, _selectedProcess$getD3, _selectedProcess$getD4;
    const hasAlerts = !!(alerts !== null && alerts !== void 0 && alerts.length);
    return [{
      id: 'process',
      name: _i18n.i18n.translate('xpack.sessionView.detailsPanel.process', {
        defaultMessage: 'Process'
      }),
      content: /*#__PURE__*/_react.default.createElement(_detail_panel_process_tab.DetailPanelProcessTab, {
        selectedProcess: selectedProcess
      })
    }, {
      id: 'metadata',
      name: _i18n.i18n.translate('xpack.sessionView.detailsPanel.metadata', {
        defaultMessage: 'Metadata'
      }),
      content: /*#__PURE__*/_react.default.createElement(_detail_panel_metadata_tab.DetailPanelMetadataTab, {
        processHost: selectedProcess === null || selectedProcess === void 0 ? void 0 : (_selectedProcess$getD = selectedProcess.getDetails()) === null || _selectedProcess$getD === void 0 ? void 0 : _selectedProcess$getD.host,
        processContainer: selectedProcess === null || selectedProcess === void 0 ? void 0 : (_selectedProcess$getD2 = selectedProcess.getDetails()) === null || _selectedProcess$getD2 === void 0 ? void 0 : _selectedProcess$getD2.container,
        processOrchestrator: selectedProcess === null || selectedProcess === void 0 ? void 0 : (_selectedProcess$getD3 = selectedProcess.getDetails()) === null || _selectedProcess$getD3 === void 0 ? void 0 : _selectedProcess$getD3.orchestrator,
        processCloud: selectedProcess === null || selectedProcess === void 0 ? void 0 : (_selectedProcess$getD4 = selectedProcess.getDetails()) === null || _selectedProcess$getD4 === void 0 ? void 0 : _selectedProcess$getD4.cloud
      })
    }, {
      id: 'alerts',
      name: _i18n.i18n.translate('xpack.sessionView.detailsPanel.alerts', {
        defaultMessage: 'Alerts'
      }),
      append: hasAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        className: "eui-alignCenter",
        size: "m"
      }, alertsCountStr),
      content: alerts && /*#__PURE__*/_react.default.createElement(_detail_panel_alert_tab.DetailPanelAlertTab, {
        alerts: alerts,
        isFetchingAlerts: isFetchingAlerts,
        hasNextPageAlerts: hasNextPageAlerts,
        fetchNextPageAlerts: fetchNextPageAlerts,
        onJumpToEvent: onJumpToEvent,
        onShowAlertDetails: onShowAlertDetails,
        investigatedAlertId: investigatedAlertId
      })
    }];
  }, [alerts, alertsCountStr, fetchNextPageAlerts, hasNextPageAlerts, isFetchingAlerts, selectedProcess, onJumpToEvent, onShowAlertDetails, investigatedAlertId]);
  const onSelectedTabChanged = (0, _react.useCallback)(id => {
    setSelectedTabId(id);
  }, []);
  const tabContent = (0, _react.useMemo)(() => (0, _helpers.getSelectedTabContent)(tabs, selectedTabId), [tabs, selectedTabId]);
  const styles = (0, _styles.useStyles)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.detailsPanel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "l",
    expand: true
  }, tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: index,
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    disabled: tab.disabled,
    prepend: tab.prepend,
    append: tab.append
  }, tab.name))), tabContent);
};
exports.SessionViewDetailPanel = SessionViewDetailPanel;