"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = ({
  depth,
  hasAlerts,
  hasInvestigatedAlert,
  isSelected,
  isSessionLeader
}) => {
  const {
    euiTheme,
    euiVars
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      colors,
      border,
      size,
      font
    } = euiTheme;
    const ALERT_INDICATOR_WIDTH = '3px';
    const LINE_HEIGHT = '21px';
    const FONT_SIZE = '13px';
    const TREE_INDENT = `calc(${size.l} + ${size.xxs})`;
    const PROCESS_TREE_LEFT_PADDING = size.s;
    const darkText = {
      color: colors.text,
      fontFamily: font.familyCode
    };
    const children = {
      position: 'relative',
      color: colors.ghost,
      marginLeft: size.base,
      paddingLeft: size.s,
      borderLeft: border.editable
    };
    const icon = {
      color: euiVars.euiColorDarkShade
    };

    /**
     * gets border, bg and hover colors for a process
     */
    const getHighlightColors = () => {
      let bgColor = 'none';
      let hoverColor = (0, _eui.transparentize)(colors.primary, 0.04);
      let borderColor = 'transparent';
      let searchResColor = (0, _eui.transparentize)(colors.warning, 0.32);
      if (hasAlerts) {
        borderColor = colors.danger;
      }
      if (isSelected) {
        searchResColor = colors.warning;
        bgColor = (0, _eui.transparentize)(colors.primary, 0.08);
        hoverColor = (0, _eui.transparentize)(colors.primary, 0.12);
      }
      if (hasInvestigatedAlert) {
        bgColor = (0, _eui.transparentize)(colors.danger, 0.04);
        hoverColor = (0, _eui.transparentize)(colors.danger, 0.12);
        if (isSelected) {
          bgColor = (0, _eui.transparentize)(colors.danger, 0.08);
        }
      }
      return {
        bgColor,
        borderColor,
        hoverColor,
        searchResColor
      };
    };
    const {
      bgColor,
      borderColor,
      hoverColor,
      searchResColor
    } = getHighlightColors();
    const fontSpacingReset = {
      fontSize: 0,
      lineHeight: 0
    };
    const processNode = {
      ...fontSpacingReset,
      display: 'block',
      cursor: 'pointer',
      position: 'relative',
      '&:hover:before': {
        backgroundColor: hoverColor
      },
      '&:before': {
        position: 'absolute',
        height: '100%',
        pointerEvents: 'none',
        content: `''`,
        marginLeft: `calc(-${depth} * ${TREE_INDENT} - ${PROCESS_TREE_LEFT_PADDING})`,
        borderLeft: `${ALERT_INDICATOR_WIDTH} solid ${borderColor}`,
        backgroundColor: bgColor,
        width: `calc(100% + ${depth} * ${TREE_INDENT} + ${PROCESS_TREE_LEFT_PADDING})`
      },
      '.euiToolTipAnchor': {
        verticalAlign: 'middle'
      }
    };
    const jumpToTop = {
      float: 'right'
    };
    const textSection = {
      marginLeft: size.s,
      span: {
        fontSize: FONT_SIZE,
        lineHeight: LINE_HEIGHT,
        verticalAlign: 'middle'
      }
    };
    const sessionLeader = {
      ...fontSpacingReset,
      'span, b': {
        fontSize: FONT_SIZE,
        lineHeight: LINE_HEIGHT,
        display: 'inline-block',
        verticalAlign: 'middle'
      },
      paddingLeft: PROCESS_TREE_LEFT_PADDING
    };
    if (isSessionLeader) {
      processNode.position = 'sticky';
      processNode.top = '-' + size.base;
      processNode.zIndex = 1;
      processNode.borderTop = `${size.base} solid transparent`;
      processNode.backgroundColor = euiVars.euiColorLightestShade;
      processNode.borderBottom = border.editable;
    }
    const searchHighlight = {
      color: colors.fullShade,
      borderRadius: '0px',
      backgroundColor: searchResColor
    };
    const wrapper = {
      paddingLeft: size.s,
      position: 'relative',
      verticalAlign: 'middle',
      color: euiVars.euiTextSubduedColor,
      wordBreak: 'break-all',
      padding: `${size.xs} 0px`,
      button: {
        marginLeft: '6px',
        marginRight: size.xxs
      }
    };
    const workingDir = {
      color: colors.successText,
      fontFamily: font.familyCode,
      fontWeight: font.weight.regular
    };
    const timeStamp = {
      float: 'right',
      fontFamily: font.familyCode,
      fontSize: size.m,
      fontWeight: font.weight.regular,
      paddingRight: size.base,
      paddingLeft: size.xxl,
      position: 'relative',
      lineHeight: LINE_HEIGHT,
      marginTop: '1px'
    };
    const alertDetails = {
      padding: size.s,
      border: border.editable,
      borderRadius: border.radius.medium
    };
    return {
      darkText,
      searchHighlight,
      children,
      processNode,
      wrapper,
      workingDir,
      timeStamp,
      alertDetails,
      icon,
      textSection,
      sessionLeader,
      jumpToTop
    };
  }, [depth, euiTheme, hasAlerts, hasInvestigatedAlert, isSelected, euiVars, isSessionLeader]);
  return cached;
};
exports.useStyles = useStyles;