"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputButton = exports.OUTPUT = exports.ChildrenProcessesButton = exports.CHILD_PROCESSES = exports.AlertButton = exports.ALERTS = exports.ALERT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_button_styles = require("./use_button_styles");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ALERT_COUNT = 99;
const CHILD_PROCESSES = _i18n.i18n.translate('xpack.sessionView.childProcesses', {
  defaultMessage: 'Child processes'
});
exports.CHILD_PROCESSES = CHILD_PROCESSES;
const ALERTS = _i18n.i18n.translate('xpack.sessionView.alerts', {
  defaultMessage: 'Alerts'
});
exports.ALERTS = ALERTS;
const ALERT = _i18n.i18n.translate('xpack.sessionView.alert', {
  defaultMessage: 'Alert'
});
exports.ALERT = ALERT;
const OUTPUT = _i18n.i18n.translate('xpack.sessionView.output', {
  defaultMessage: 'Output'
});
exports.OUTPUT = OUTPUT;
const ChildrenProcessesButton = ({
  onToggle,
  isExpanded
}) => {
  const {
    button,
    buttonArrow
  } = (0, _use_button_styles.useButtonStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: isExpanded ? 'isExpanded' : '',
    key: "child-processes-button",
    css: button,
    onClick: onToggle,
    "data-test-subj": "sessionView:processTreeNodeChildProcessesButton",
    "aria-label": CHILD_PROCESSES
  }, CHILD_PROCESSES, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: buttonArrow,
    size: "s",
    type: "arrowDown"
  }));
};
exports.ChildrenProcessesButton = ChildrenProcessesButton;
const AlertButton = ({
  isExpanded,
  alertTypeCounts,
  onToggle,
  alertsCount
}) => {
  const {
    alertButton,
    buttonArrow
  } = (0, _use_button_styles.useButtonStyles)();
  const alertIcons = (0, _react.useMemo)(() => {
    var _alertTypeCounts$filt;
    return alertTypeCounts === null || alertTypeCounts === void 0 ? void 0 : (_alertTypeCounts$filt = alertTypeCounts.filter(alertTypeCount => alertTypeCount.count > 0)) === null || _alertTypeCounts$filt === void 0 ? void 0 : _alertTypeCounts$filt.map(({
      category
    }, i) => _constants.ALERT_ICONS[category]);
  }, [alertTypeCounts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: isExpanded ? 'isExpanded' : '',
    key: "alert-button",
    css: alertButton,
    onClick: onToggle,
    "data-test-subj": "processTreeNodeAlertButton",
    "aria-label": ALERTS
  }, alertsCount > 1 ? ALERTS : ALERT, alertsCount > 1 && (alertsCount > MAX_ALERT_COUNT ? ` (${MAX_ALERT_COUNT}+)` : ` (${alertsCount})`), alertIcons === null || alertIcons === void 0 ? void 0 : alertIcons.map(icon => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    className: "alertIcon",
    key: icon,
    size: "s",
    type: icon
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: buttonArrow,
    size: "s",
    type: "arrowDown"
  }));
};
exports.AlertButton = AlertButton;
const OutputButton = ({
  onClick
}) => {
  const {
    outputButton,
    buttonArrow
  } = (0, _use_button_styles.useButtonStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    key: "output-button",
    css: outputButton,
    onClick: onClick,
    "data-test-subj": "processTreeNodeOutpuButton",
    "aria-label": OUTPUT
  }, OUTPUT, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: buttonArrow,
    size: "s",
    type: "arrowRight"
  }));
};
exports.OutputButton = OutputButton;