"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = ({
  isInvestigated,
  isSelected
}) => {
  const {
    euiTheme,
    euiVars
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      size,
      colors,
      font,
      border
    } = euiTheme;
    const getHighlightColors = () => {
      let bgColor = 'none';
      let hoverBgColor = `${(0, _eui.transparentize)(colors.primary, 0.04)}`;
      if (isInvestigated && isSelected) {
        bgColor = `${(0, _eui.transparentize)(colors.danger, 0.08)}`;
        hoverBgColor = `${(0, _eui.transparentize)(colors.danger, 0.12)}`;
      } else if (isInvestigated) {
        bgColor = `${(0, _eui.transparentize)(colors.danger, 0.04)}`;
        hoverBgColor = `${(0, _eui.transparentize)(colors.danger, 0.12)}`;
      } else if (isSelected) {
        bgColor = `${(0, _eui.transparentize)(colors.primary, 0.08)}`;
        hoverBgColor = `${(0, _eui.transparentize)(colors.primary, 0.12)}`;
      }
      return {
        bgColor,
        hoverBgColor
      };
    };
    const {
      bgColor,
      hoverBgColor
    } = getHighlightColors();
    const alert = {
      fontFamily: font.family,
      padding: `0 ${size.m}`,
      cursor: 'pointer',
      '&:not(:last-child)': {
        marginBottom: size.s
      },
      background: bgColor,
      '&:hover': {
        background: hoverBgColor
      },
      '&& button': {
        flexShrink: 0,
        marginRight: size.xs,
        '&:hover, &:focus, &:focus-within': {
          backgroundColor: (0, _eui.transparentize)(euiVars.buttonsBackgroundNormalDefaultPrimary, 0.2)
        }
      },
      '&& .euiFlexItem': {
        marginTop: size.xxs,
        marginBottom: size.xxs
      }
    };
    const alertStatus = {
      textTransform: 'capitalize'
    };
    const processAlertDisplayContainer = {
      display: 'flex',
      alignItems: 'center'
    };
    const alertName = {
      color: colors.title,
      '& .alertCategoryDetailText': {
        fontSize: size.m
      }
    };
    const actionBadge = {
      textTransform: 'capitalize'
    };
    const processPanel = {
      marginLeft: '8px',
      border: `${border.width.thin} solid ${colors.lightShade}`,
      fontFamily: font.familyCode,
      padding: `${size.xs} ${size.s}`
    };
    return {
      alert,
      alertStatus,
      alertName,
      actionBadge,
      processPanel,
      processAlertDisplayContainer
    };
  }, [euiTheme, isInvestigated, isSelected, euiVars]);
  return cached;
};
exports.useStyles = useStyles;