"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProcessExecutableCopyText = exports.getDetailPanelProcess = exports.formatProcessArgs = void 0;
var _process_tree = require("../../../common/types/process_tree");
var _constants = require("../../constants");
var _data_or_dash = require("../../utils/data_or_dash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PROCESS_DATA = {
  id: _constants.DASH,
  name: _constants.DASH,
  start: _constants.DASH,
  end: _constants.DASH,
  exitCode: _constants.DASH,
  userId: _constants.DASH,
  userName: _constants.DASH,
  groupId: _constants.DASH,
  groupName: _constants.DASH,
  workingDirectory: _constants.DASH,
  interactive: _constants.DASH,
  args: _constants.DASH,
  pid: _constants.DASH,
  entryMetaType: _constants.DASH,
  entryMetaSourceIp: _constants.DASH,
  executable: [[_constants.DASH]]
};

/**
 * Serialize an array of executable tuples to a copyable text.
 *
 * @param  {String[][]} executable
 * @return {String} serialized string with data of each executable
 */
const getProcessExecutableCopyText = executable => {
  try {
    return executable.map(execTuple => {
      const [execCommand, eventAction] = execTuple;
      if (!execCommand || !eventAction || execTuple.length !== 2) {
        throw new Error();
      }
      return `${execCommand} ${eventAction}`;
    }).join(', ');
  } catch (_) {
    return '';
  }
};

/**
 * Format an array of args for display.
 *
 * @param  {String[] | undefined} args
 * @return {String} formatted string of process args
 */
exports.getProcessExecutableCopyText = getProcessExecutableCopyText;
const formatProcessArgs = args => args && args.length && args.map ? `[${args.map(arg => `'${arg}'`).join(', ')}]` : _constants.DASH;
exports.formatProcessArgs = formatProcessArgs;
const getDetailPanelProcessLeader = leader => {
  var _leader$entity_id, _leader$name, _leader$start, _leader$end, _leader$exit_code$toS, _leader$exit_code, _leader$user$id, _leader$user, _leader$user$name, _leader$user2, _leader$group$id, _leader$group, _leader$group$name, _leader$group2, _leader$working_direc, _formatProcessArgs, _leader$pid$toString, _leader$pid, _leader$entry_meta$ty, _leader$entry_meta, _leader$entry_meta$so, _leader$entry_meta2, _leader$entry_meta2$s;
  return {
    ...leader,
    id: (_leader$entity_id = leader === null || leader === void 0 ? void 0 : leader.entity_id) !== null && _leader$entity_id !== void 0 ? _leader$entity_id : DEFAULT_PROCESS_DATA.id,
    name: (_leader$name = leader === null || leader === void 0 ? void 0 : leader.name) !== null && _leader$name !== void 0 ? _leader$name : DEFAULT_PROCESS_DATA.name,
    start: (_leader$start = leader === null || leader === void 0 ? void 0 : leader.start) !== null && _leader$start !== void 0 ? _leader$start : DEFAULT_PROCESS_DATA.start,
    end: (_leader$end = leader === null || leader === void 0 ? void 0 : leader.end) !== null && _leader$end !== void 0 ? _leader$end : DEFAULT_PROCESS_DATA.end,
    exitCode: (_leader$exit_code$toS = leader === null || leader === void 0 ? void 0 : (_leader$exit_code = leader.exit_code) === null || _leader$exit_code === void 0 ? void 0 : _leader$exit_code.toString()) !== null && _leader$exit_code$toS !== void 0 ? _leader$exit_code$toS : DEFAULT_PROCESS_DATA.exitCode,
    interactive: leader !== null && leader !== void 0 && leader.interactive ? 'True' : 'False',
    userId: (_leader$user$id = leader === null || leader === void 0 ? void 0 : (_leader$user = leader.user) === null || _leader$user === void 0 ? void 0 : _leader$user.id) !== null && _leader$user$id !== void 0 ? _leader$user$id : DEFAULT_PROCESS_DATA.userId,
    userName: (_leader$user$name = leader === null || leader === void 0 ? void 0 : (_leader$user2 = leader.user) === null || _leader$user2 === void 0 ? void 0 : _leader$user2.name) !== null && _leader$user$name !== void 0 ? _leader$user$name : DEFAULT_PROCESS_DATA.userName,
    groupId: (_leader$group$id = leader === null || leader === void 0 ? void 0 : (_leader$group = leader.group) === null || _leader$group === void 0 ? void 0 : _leader$group.id) !== null && _leader$group$id !== void 0 ? _leader$group$id : DEFAULT_PROCESS_DATA.groupId,
    groupName: (_leader$group$name = leader === null || leader === void 0 ? void 0 : (_leader$group2 = leader.group) === null || _leader$group2 === void 0 ? void 0 : _leader$group2.name) !== null && _leader$group$name !== void 0 ? _leader$group$name : DEFAULT_PROCESS_DATA.groupName,
    workingDirectory: (_leader$working_direc = leader === null || leader === void 0 ? void 0 : leader.working_directory) !== null && _leader$working_direc !== void 0 ? _leader$working_direc : DEFAULT_PROCESS_DATA.workingDirectory,
    args: (_formatProcessArgs = formatProcessArgs(leader === null || leader === void 0 ? void 0 : leader.args)) !== null && _formatProcessArgs !== void 0 ? _formatProcessArgs : DEFAULT_PROCESS_DATA.args,
    pid: (_leader$pid$toString = leader === null || leader === void 0 ? void 0 : (_leader$pid = leader.pid) === null || _leader$pid === void 0 ? void 0 : _leader$pid.toString()) !== null && _leader$pid$toString !== void 0 ? _leader$pid$toString : DEFAULT_PROCESS_DATA.pid,
    // TODO: get the event action of leader
    executable: leader !== null && leader !== void 0 && leader.executable ? [[leader === null || leader === void 0 ? void 0 : leader.executable]] : DEFAULT_PROCESS_DATA.executable,
    entryMetaType: (_leader$entry_meta$ty = leader === null || leader === void 0 ? void 0 : (_leader$entry_meta = leader.entry_meta) === null || _leader$entry_meta === void 0 ? void 0 : _leader$entry_meta.type) !== null && _leader$entry_meta$ty !== void 0 ? _leader$entry_meta$ty : DEFAULT_PROCESS_DATA.entryMetaType,
    entryMetaSourceIp: (_leader$entry_meta$so = leader === null || leader === void 0 ? void 0 : (_leader$entry_meta2 = leader.entry_meta) === null || _leader$entry_meta2 === void 0 ? void 0 : (_leader$entry_meta2$s = _leader$entry_meta2.source) === null || _leader$entry_meta2$s === void 0 ? void 0 : _leader$entry_meta2$s.ip) !== null && _leader$entry_meta$so !== void 0 ? _leader$entry_meta$so : DEFAULT_PROCESS_DATA.entryMetaSourceIp
  };
};
const getDetailPanelProcess = process => {
  var _details$process, _details$process2, _details$process3, _details$process4, _details$process4$use, _details$process5, _details$process5$use, _details$process6, _details$process6$gro, _details$process7, _details$process7$gro, _details$process8, _details$process9, _details$process10, _details$process11, _details$process11$pr, _details$process12, _details$process13, _details$process14, _details$process15, _details$process16;
  const processData = {
    id: DEFAULT_PROCESS_DATA.id,
    start: DEFAULT_PROCESS_DATA.start,
    end: DEFAULT_PROCESS_DATA.end,
    exitCode: DEFAULT_PROCESS_DATA.exitCode,
    interactive: DEFAULT_PROCESS_DATA.interactive,
    userId: DEFAULT_PROCESS_DATA.userId,
    userName: DEFAULT_PROCESS_DATA.userName,
    groupName: DEFAULT_PROCESS_DATA.groupName,
    args: DEFAULT_PROCESS_DATA.args,
    pid: DEFAULT_PROCESS_DATA.pid,
    executable: DEFAULT_PROCESS_DATA.executable,
    workingDirectory: DEFAULT_PROCESS_DATA.workingDirectory,
    entryLeader: DEFAULT_PROCESS_DATA,
    sessionLeader: DEFAULT_PROCESS_DATA,
    groupLeader: DEFAULT_PROCESS_DATA,
    parent: DEFAULT_PROCESS_DATA
  };
  if (!process) {
    return processData;
  }
  const details = process.getDetails();
  processData.id = `${(0, _data_or_dash.dataOrDash)(process.id)}`;
  processData.start = `${(0, _data_or_dash.dataOrDash)((_details$process = details.process) === null || _details$process === void 0 ? void 0 : _details$process.start)}`;
  processData.end = `${(0, _data_or_dash.dataOrDash)(process.getEndTime())}`;
  processData.exitCode = `${(0, _data_or_dash.dataOrDash)((_details$process2 = details.process) === null || _details$process2 === void 0 ? void 0 : _details$process2.exit_code)}`;
  processData.interactive = (_details$process3 = details.process) !== null && _details$process3 !== void 0 && _details$process3.interactive ? 'True' : 'False';
  processData.userId = `${(0, _data_or_dash.dataOrDash)((_details$process4 = details.process) === null || _details$process4 === void 0 ? void 0 : (_details$process4$use = _details$process4.user) === null || _details$process4$use === void 0 ? void 0 : _details$process4$use.id)}`;
  processData.userName = `${(0, _data_or_dash.dataOrDash)((_details$process5 = details.process) === null || _details$process5 === void 0 ? void 0 : (_details$process5$use = _details$process5.user) === null || _details$process5$use === void 0 ? void 0 : _details$process5$use.name)}`;
  processData.groupId = `${(0, _data_or_dash.dataOrDash)((_details$process6 = details.process) === null || _details$process6 === void 0 ? void 0 : (_details$process6$gro = _details$process6.group) === null || _details$process6$gro === void 0 ? void 0 : _details$process6$gro.id)}`;
  processData.groupName = `${(0, _data_or_dash.dataOrDash)((_details$process7 = details.process) === null || _details$process7 === void 0 ? void 0 : (_details$process7$gro = _details$process7.group) === null || _details$process7$gro === void 0 ? void 0 : _details$process7$gro.name)}`;
  processData.pid = `${(0, _data_or_dash.dataOrDash)((_details$process8 = details.process) === null || _details$process8 === void 0 ? void 0 : _details$process8.pid)}`;
  processData.workingDirectory = `${(0, _data_or_dash.dataOrDash)((_details$process9 = details.process) === null || _details$process9 === void 0 ? void 0 : _details$process9.working_directory)}`;
  if ((_details$process10 = details.process) !== null && _details$process10 !== void 0 && _details$process10.args) {
    processData.args = formatProcessArgs(details.process.args);
  }

  // we grab the executable from each process lifecycle event to give an indication
  // of the processes journey. Processes can sometimes exec multiple times, so it's good
  // information to have.
  const executables = ((_details$process11 = details.process) === null || _details$process11 === void 0 ? void 0 : (_details$process11$pr = _details$process11.previous) === null || _details$process11$pr === void 0 ? void 0 : _details$process11$pr.map(exe => (exe === null || exe === void 0 ? void 0 : exe.executable) || '')) || [];
  if ((_details$process12 = details.process) !== null && _details$process12 !== void 0 && _details$process12.executable) {
    executables.push(details.process.executable);
  }
  processData.executable = executables.map((exe, i) => {
    const action = i === 0 ? _process_tree.EventAction.fork : _process_tree.EventAction.exec;
    return [exe, `(${action})`];
  });
  processData.entryLeader = getDetailPanelProcessLeader(details === null || details === void 0 ? void 0 : (_details$process13 = details.process) === null || _details$process13 === void 0 ? void 0 : _details$process13.entry_leader);
  processData.sessionLeader = getDetailPanelProcessLeader(details === null || details === void 0 ? void 0 : (_details$process14 = details.process) === null || _details$process14 === void 0 ? void 0 : _details$process14.session_leader);
  processData.groupLeader = getDetailPanelProcessLeader(details === null || details === void 0 ? void 0 : (_details$process15 = details.process) === null || _details$process15 === void 0 ? void 0 : _details$process15.group_leader);
  processData.parent = getDetailPanelProcessLeader(details === null || details === void 0 ? void 0 : (_details$process16 = details.process) === null || _details$process16 === void 0 ? void 0 : _details$process16.parent);
  return processData;
};
exports.getDetailPanelProcess = getDetailPanelProcess;