"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decodeRequestParams = decodeRequestParams;
var _lodash = require("lodash");
var _Either = require("fp-ts/lib/Either");
var _PathReporter = require("io-ts/lib/PathReporter");
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _ioTsUtils = require("@kbn/io-ts-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function decodeRequestParams(params, paramsRt) {
  const paramMap = (0, _lodash.omitBy)({
    path: params.params,
    body: params.body,
    query: params.query
  }, val => val === null || val === undefined || (0, _lodash.isPlainObject)(val) && (0, _lodash.isEmpty)(val));

  // decode = validate
  const result = (0, _ioTsUtils.strictKeysRt)(paramsRt).decode(paramMap);
  if ((0, _Either.isLeft)(result)) {
    throw _boom.default.badRequest(_PathReporter.PathReporter.report(result)[0]);
  }
  return result.right;
}