"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeDuration = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isTimeSafe = time => time >= 1 && Number.isSafeInteger(time);
const TimeDuration = ({
  allowedUnits,
  allowedDurations
}) => {
  return new t.Type('TimeDuration', t.string.is, (input, context) => {
    if (typeof input === 'string' && input.trim() !== '') {
      try {
        const inputLength = input.length;
        const time = Number(input.trim().substring(0, inputLength - 1));
        const unit = input.trim().at(-1);
        if (!isTimeSafe(time)) {
          return t.failure(input, context);
        }
        if (allowedDurations) {
          for (const [allowedTime, allowedUnit] of allowedDurations) {
            if (!isTimeSafe(allowedTime)) {
              return t.failure(allowedDurations, context);
            }
            if (allowedTime === time && allowedUnit === unit) {
              return t.success(input);
            }
          }
          return t.failure(input, context);
        } else if (allowedUnits.includes(unit)) {
          return t.success(input);
        } else {
          return t.failure(input, context);
        }
      } catch (error) {
        return t.failure(input, context);
      }
    } else {
      return t.failure(input, context);
    }
  }, t.identity);
};
exports.TimeDuration = TimeDuration;