"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.managedUserDetails = void 0;
var _build_query = require("../../../../../utils/build_query");
var _queryManaged_user_details = require("./query.managed_user_details.dsl");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const managedUserDetails = {
  buildDsl: options => (0, _queryManaged_user_details.buildManagedUserDetailsQuery)(options),
  parse: async (options, response) => {
    const inspect = {
      dsl: [(0, _build_query.inspectStringifyObject)((0, _queryManaged_user_details.buildManagedUserDetailsQuery)(options))]
    };
    const hits = response.rawResponse.hits.hits;
    const userDetails = hits.length > 0 ? hits[0]._source : undefined;
    return {
      ...response,
      inspect,
      userDetails
    };
  }
};
exports.managedUserDetails = managedUserDetails;