"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldFilterByCardinality = exports.getThresholdTermsHash = exports.calculateThresholdSignalUuid = void 0;
var _crypto = require("crypto");
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const shouldFilterByCardinality = threshold => {
  var _threshold$cardinalit;
  return !!((_threshold$cardinalit = threshold.cardinality) !== null && _threshold$cardinalit !== void 0 && _threshold$cardinalit.length);
};
exports.shouldFilterByCardinality = shouldFilterByCardinality;
const calculateThresholdSignalUuid = (ruleId, startedAt, thresholdFields, key) => {
  // used to generate stable Threshold Signals ID when run with the same params
  const NAMESPACE_ID = '0684ec03-7201-4ee0-8ee0-3a3f6b2479b2';
  const startedAtString = startedAt.toISOString();
  const keyString = key !== null && key !== void 0 ? key : '';
  const baseString = `${ruleId}${startedAtString}${thresholdFields.join(',')}${keyString}`;
  return (0, _uuid.v5)(baseString, NAMESPACE_ID);
};
exports.calculateThresholdSignalUuid = calculateThresholdSignalUuid;
const getThresholdTermsHash = terms => {
  return (0, _crypto.createHash)('sha256').update(terms.sort((term1, term2) => term1.field > term2.field ? 1 : -1).map(term => {
    return `${term.field}:${term.value}`;
  }).join(',')).digest('hex');
};
exports.getThresholdTermsHash = getThresholdTermsHash;