"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidLongType = void 0;
var _is_valid_numeric_type = require("./is_valid_numeric_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * validates ES long type
 */
const isValidLongType = value => {
  // long type can't have any spaces if string
  if (typeof value === 'string' && value.includes(' ')) {
    return false;
  }
  return (0, _is_valid_numeric_type.isValidNumericType)(value);
};
exports.isValidLongType = isValidLongType;