"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScheduleNotificationResponseActionsService = void 0;
var _lodash = require("lodash");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _schemas = require("../../../../common/detection_engine/rule_response_actions/schemas");
var _osquery_response_action = require("./osquery_response_action");
var _endpoint_response_action = require("./endpoint_response_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getScheduleNotificationResponseActionsService = ({
  osqueryCreateAction,
  endpointAppContextService
}) => ({
  signals,
  responseActions,
  hasEnterpriseLicense
}) => {
  const filteredAlerts = signals.filter(alert => {
    var _alert$agent;
    return (_alert$agent = alert.agent) === null || _alert$agent === void 0 ? void 0 : _alert$agent.id;
  });
  const {
    alerts,
    agentIds,
    alertIds
  } = (0, _lodash.reduce)(filteredAlerts, (acc, alert) => {
    var _alert$agent2;
    const agentId = (_alert$agent2 = alert.agent) === null || _alert$agent2 === void 0 ? void 0 : _alert$agent2.id;
    if (agentId !== undefined) {
      return {
        alerts: [...acc.alerts, alert],
        agentIds: (0, _lodash.uniq)([...acc.agentIds, agentId]),
        alertIds: [...acc.alertIds, alert._id]
      };
    }
    return acc;
  }, {
    alerts: [],
    agentIds: [],
    alertIds: []
  });
  (0, _lodash.each)(responseActions, responseAction => {
    if (responseAction.actionTypeId === _schemas.RESPONSE_ACTION_TYPES.OSQUERY && osqueryCreateAction) {
      (0, _osquery_response_action.osqueryResponseAction)(responseAction, osqueryCreateAction, {
        alerts,
        alertIds,
        agentIds
      });
    }
    if (responseAction.actionTypeId === _schemas.RESPONSE_ACTION_TYPES.ENDPOINT && hasEnterpriseLicense) {
      (0, _endpoint_response_action.endpointResponseAction)(responseAction, endpointAppContextService, {
        alerts,
        alertIds,
        agentIds,
        ruleId: alerts[0][_ruleDataUtils.ALERT_RULE_UUID],
        ruleName: alerts[0][_ruleDataUtils.ALERT_RULE_NAME]
      });
    }
  });
};
exports.getScheduleNotificationResponseActionsService = getScheduleNotificationResponseActionsService;