"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.osqueryResponseAction = void 0;
var _lodash = require("lodash");
var _replace_params_query = require("@kbn/osquery-plugin/common/utils/replace_params_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const osqueryResponseAction = (responseAction, osqueryCreateAction, {
  alerts,
  alertIds,
  agentIds
}) => {
  var _responseAction$param;
  const temporaryQueries = (_responseAction$param = responseAction.params.queries) !== null && _responseAction$param !== void 0 && _responseAction$param.length ? responseAction.params.queries : [{
    query: responseAction.params.query
  }];
  const containsDynamicQueries = (0, _lodash.some)(temporaryQueries, query => query.query && (0, _replace_params_query.containsDynamicQuery)(query.query));
  const {
    savedQueryId,
    packId,
    queries,
    ecsMapping,
    ...rest
  } = responseAction.params;
  if (!containsDynamicQueries) {
    return osqueryCreateAction({
      ...rest,
      queries,
      ecs_mapping: ecsMapping,
      saved_query_id: savedQueryId,
      agent_ids: agentIds,
      alert_ids: alertIds
    });
  }
  (0, _lodash.each)(alerts, alert => {
    var _alert$agent;
    return osqueryCreateAction({
      ...rest,
      queries,
      ecs_mapping: ecsMapping,
      saved_query_id: savedQueryId,
      agent_ids: (_alert$agent = alert.agent) !== null && _alert$agent !== void 0 && _alert$agent.id ? [alert.agent.id] : [],
      alert_ids: [alert._id]
    }, alert);
  });
};
exports.osqueryResponseAction = osqueryResponseAction;