"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.endpointResponseAction = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const endpointResponseAction = (responseAction, endpointAppContextService, {
  alertIds,
  agentIds,
  ruleId,
  ruleName
}) => (0, _lodash.each)(agentIds, agent => endpointAppContextService.getActionCreateService().createAction({
  endpoint_ids: [agent],
  alert_ids: alertIds,
  comment: responseAction.params.comment,
  command: responseAction.params.command,
  rule_id: ruleId,
  rule_name: ruleName
}));
exports.endpointResponseAction = endpointResponseAction;