"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRuleMonitoringService = void 0;
var _invariant = require("../../../../../common/utils/invariant");
var _with_security_span = require("../../../../utils/with_security_span");
var _client = require("./rule_execution_log/client_for_routes/client");
var _client2 = require("./rule_execution_log/client_for_executors/client");
var _register_event_log_provider = require("./event_log/register_event_log_provider");
var _detection_engine_health_client = require("./detection_engine_health/detection_engine_health_client");
var _event_log_health_client = require("./detection_engine_health/event_log/event_log_health_client");
var _rule_objects_health_client = require("./detection_engine_health/rule_objects/rule_objects_health_client");
var _event_log_reader = require("./rule_execution_log/event_log/event_log_reader");
var _event_log_writer = require("./rule_execution_log/event_log/event_log_writer");
var _fetch_rule_execution_settings = require("./rule_execution_log/execution_settings/fetch_rule_execution_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRuleMonitoringService = (config, logger, core, plugins) => {
  return {
    registerEventLogProvider: () => {
      (0, _register_event_log_provider.registerEventLogProvider)(plugins.eventLog);
    },
    createDetectionEngineHealthClient: params => {
      const {
        rulesClient,
        eventLogClient,
        currentSpaceId
      } = params;
      const ruleObjectsHealthClient = (0, _rule_objects_health_client.createRuleObjectsHealthClient)(rulesClient);
      const eventLogHealthClient = (0, _event_log_health_client.createEventLogHealthClient)(eventLogClient);
      return (0, _detection_engine_health_client.createDetectionEngineHealthClient)(ruleObjectsHealthClient, eventLogHealthClient, logger, currentSpaceId);
    },
    createRuleExecutionLogClientForRoutes: params => {
      const {
        eventLogClient
      } = params;
      const eventLogReader = (0, _event_log_reader.createEventLogReader)(eventLogClient);
      return (0, _client.createRuleExecutionLogClientForRoutes)(eventLogReader, logger);
    },
    createRuleExecutionLogClientForExecutors: params => {
      return (0, _with_security_span.withSecuritySpan)('IRuleMonitoringService.createRuleExecutionLogClientForExecutors', async () => {
        const {
          savedObjectsClient,
          context,
          ruleMonitoringService,
          ruleResultService
        } = params;
        (0, _invariant.invariant)(ruleMonitoringService, 'ruleMonitoringService required for detection rules');
        (0, _invariant.invariant)(ruleResultService, 'ruleResultService required for detection rules');
        const childLogger = logger.get('ruleExecution');
        const ruleExecutionSettings = await (0, _fetch_rule_execution_settings.fetchRuleExecutionSettings)(config, childLogger, core, savedObjectsClient);
        const eventLogWriter = (0, _event_log_writer.createEventLogWriter)(plugins.eventLog);
        return (0, _client2.createRuleExecutionLogClientForExecutors)(ruleExecutionSettings, eventLogWriter, childLogger, context, ruleMonitoringService, ruleResultService);
      });
    }
  };
};
exports.createRuleMonitoringService = createRuleMonitoringService;