"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMESTAMP = exports.RULE_EXECUTION_UUID = exports.RULE_EXECUTION_TOTAL_DURATION_MS = exports.RULE_EXECUTION_STATUS = exports.RULE_EXECUTION_SEARCH_DURATION_MS = exports.RULE_EXECUTION_SCHEDULE_DELAY_NS = exports.RULE_EXECUTION_OUTCOME = exports.RULE_EXECUTION_INDEXING_DURATION_MS = exports.RULE_EXECUTION_GAP_DURATION_S = exports.NUMBER_OF_ALERTS_GENERATED = exports.LOG_LEVEL = exports.EVENT_SEQUENCE = exports.EVENT_PROVIDER = exports.EVENT_ACTION = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// -------------------------------------------------------------------------------------------------
// ECS fields

const TIMESTAMP = `@timestamp`;
exports.TIMESTAMP = TIMESTAMP;
const EVENT_PROVIDER = 'event.provider';
exports.EVENT_PROVIDER = EVENT_PROVIDER;
const EVENT_ACTION = 'event.action';
exports.EVENT_ACTION = EVENT_ACTION;
const EVENT_SEQUENCE = 'event.sequence';
exports.EVENT_SEQUENCE = EVENT_SEQUENCE;
const LOG_LEVEL = 'log.level';

// -------------------------------------------------------------------------------------------------
// Custom fields of Alerting Framework and Security Solution
exports.LOG_LEVEL = LOG_LEVEL;
const RULE_EXECUTION = 'kibana.alert.rule.execution';
const RULE_EXECUTION_METRICS = `${RULE_EXECUTION}.metrics`;
const RULE_EXECUTION_UUID = `${RULE_EXECUTION}.uuid`;
exports.RULE_EXECUTION_UUID = RULE_EXECUTION_UUID;
const RULE_EXECUTION_OUTCOME = 'kibana.alerting.outcome';
exports.RULE_EXECUTION_OUTCOME = RULE_EXECUTION_OUTCOME;
const RULE_EXECUTION_STATUS = `${RULE_EXECUTION}.status`;
exports.RULE_EXECUTION_STATUS = RULE_EXECUTION_STATUS;
const RULE_EXECUTION_TOTAL_DURATION_MS = `${RULE_EXECUTION_METRICS}.total_run_duration_ms`;
exports.RULE_EXECUTION_TOTAL_DURATION_MS = RULE_EXECUTION_TOTAL_DURATION_MS;
const RULE_EXECUTION_SEARCH_DURATION_MS = `${RULE_EXECUTION_METRICS}.total_search_duration_ms`;
exports.RULE_EXECUTION_SEARCH_DURATION_MS = RULE_EXECUTION_SEARCH_DURATION_MS;
const RULE_EXECUTION_INDEXING_DURATION_MS = `${RULE_EXECUTION_METRICS}.total_indexing_duration_ms`;
exports.RULE_EXECUTION_INDEXING_DURATION_MS = RULE_EXECUTION_INDEXING_DURATION_MS;
const RULE_EXECUTION_GAP_DURATION_S = `${RULE_EXECUTION_METRICS}.execution_gap_duration_s`;
exports.RULE_EXECUTION_GAP_DURATION_S = RULE_EXECUTION_GAP_DURATION_S;
const RULE_EXECUTION_SCHEDULE_DELAY_NS = 'kibana.task.schedule_delay';
exports.RULE_EXECUTION_SCHEDULE_DELAY_NS = RULE_EXECUTION_SCHEDULE_DELAY_NS;
const NUMBER_OF_ALERTS_GENERATED = `${RULE_EXECUTION_METRICS}.alert_counts.new`;
exports.NUMBER_OF_ALERTS_GENERATED = NUMBER_OF_ALERTS_GENERATED;