"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchRuleById = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _read_rules = require("../../../../rule_management/logic/crud/read_rules");
var _utils = require("../../../../rule_management/utils/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: https://github.com/elastic/kibana/issues/125642 Move to rule_management into a RuleManagementClient

const fetchRuleById = async (rulesClient, id) => {
  const rawRule = await (0, _read_rules.readRules)({
    id,
    rulesClient,
    ruleId: undefined
  });
  if (rawRule == null) {
    throw _boom.default.notFound(`Rule not found, id: "${id}" `);
  }
  const normalizedRule = (0, _utils.transform)(rawRule);
  if (normalizedRule == null) {
    throw _boom.default.internal('Internal error normalizing rule object');
  }
  return normalizedRule;
};
exports.fetchRuleById = fetchRuleById;