"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEventLogHealthClient = void 0;
var f = _interopRequireWildcard(require("../../event_log/event_log_fields"));
var _event_log_constants = require("../../event_log/event_log_constants");
var _kql = require("../../utils/kql");
var _health_stats_for_rule = require("./aggregations/health_stats_for_rule");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEventLogHealthClient = eventLog => {
  return {
    async calculateRuleHealth(args) {
      const {
        rule_id: ruleId,
        interval
      } = args;
      const soType = _event_log_constants.RULE_SAVED_OBJECT_TYPE;
      const soIds = [ruleId];
      const eventProviders = [_event_log_constants.RULE_EXECUTION_LOG_PROVIDER, _event_log_constants.ALERTING_PROVIDER];
      const kqlFilter = `${f.EVENT_PROVIDER}:${(0, _kql.kqlOr)(eventProviders)}`;
      const aggs = (0, _health_stats_for_rule.getRuleHealthAggregation)(interval.granularity);
      const result = await eventLog.aggregateEventsBySavedObjectIds(soType, soIds, {
        start: interval.from,
        end: interval.to,
        filter: kqlFilter,
        aggs
      });
      return (0, _health_stats_for_rule.normalizeRuleHealthAggregationResult)(result, aggs);
    },
    async calculateSpaceHealth(args) {
      const {
        interval
      } = args;
      const soType = _event_log_constants.RULE_SAVED_OBJECT_TYPE;
      const authFilter = {};
      const namespaces = undefined; // means current Kibana space
      const eventProviders = [_event_log_constants.RULE_EXECUTION_LOG_PROVIDER, _event_log_constants.ALERTING_PROVIDER];
      const kqlFilter = `${f.EVENT_PROVIDER}:${(0, _kql.kqlOr)(eventProviders)}`;
      const aggs = (0, _health_stats_for_rule.getRuleHealthAggregation)(interval.granularity);

      // TODO: https://github.com/elastic/kibana/issues/125642 Check with ResponseOps that this is correct usage of this method
      const result = await eventLog.aggregateEventsWithAuthFilter(soType, authFilter, {
        start: interval.from,
        end: interval.to,
        filter: kqlFilter,
        aggs
      }, namespaces);
      return (0, _health_stats_for_rule.normalizeRuleHealthAggregationResult)(result, aggs);
    },
    async calculateClusterHealth(args) {
      // TODO: https://github.com/elastic/kibana/issues/125642 Implement
      return {
        stats_over_interval: {
          message: 'Not implemented'
        },
        history_over_interval: {
          buckets: []
        },
        debug: {
          eventLog: {
            request: {},
            response: {}
          }
        }
      };
    }
  };
};
exports.createEventLogHealthClient = createEventLogHealthClient;