"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRuleMonitoringRoutes = void 0;
var _get_cluster_health_route = require("./detection_engine_health/get_cluster_health/get_cluster_health_route");
var _get_rule_health_route = require("./detection_engine_health/get_rule_health/get_rule_health_route");
var _get_space_health_route = require("./detection_engine_health/get_space_health/get_space_health_route");
var _get_rule_execution_events_route = require("./rule_execution_logs/get_rule_execution_events/get_rule_execution_events_route");
var _get_rule_execution_results_route = require("./rule_execution_logs/get_rule_execution_results/get_rule_execution_results_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRuleMonitoringRoutes = router => {
  // Detection Engine health API
  (0, _get_cluster_health_route.getClusterHealthRoute)(router);
  (0, _get_space_health_route.getSpaceHealthRoute)(router);
  (0, _get_rule_health_route.getRuleHealthRoute)(router);

  // Rule execution logs API
  (0, _get_rule_execution_events_route.getRuleExecutionEventsRoute)(router);
  (0, _get_rule_execution_results_route.getRuleExecutionResultsRoute)(router);
};
exports.registerRuleMonitoringRoutes = registerRuleMonitoringRoutes;