"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPrebuiltRuleObjectsClient = void 0;
var _with_security_span = require("../../../../../utils/with_security_span");
var _get_existing_prepackaged_rules = require("../../../rule_management/logic/search/get_existing_prepackaged_rules");
var _rule_converters = require("../../../rule_management/normalization/rule_converters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPrebuiltRuleObjectsClient = rulesClient => {
  return {
    fetchInstalledRules: () => {
      return (0, _with_security_span.withSecuritySpan)('IPrebuiltRuleObjectsClient.fetchInstalledRules', async () => {
        const rulesData = await (0, _get_existing_prepackaged_rules.getExistingPrepackagedRules)({
          rulesClient
        });
        const rules = rulesData.map(rule => (0, _rule_converters.internalRuleToAPIResponse)(rule));
        const versions = rules.map(rule => convertRuleToVersionInfo(rule));
        return {
          installedRules: rules,
          installedVersions: versions
        };
      });
    }
  };
};
exports.createPrebuiltRuleObjectsClient = createPrebuiltRuleObjectsClient;
const convertRuleToVersionInfo = rule => {
  const versionInfo = {
    rule_id: rule.rule_id,
    version: rule.version
  };
  return versionInfo;
};