"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePrebuiltRuleAssets = exports.validatePrebuiltRuleAsset = void 0;
var _Either = require("fp-ts/lib/Either");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _prebuilt_rule_asset = require("../../model/rule_assets/prebuilt_rule_asset");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validatePrebuiltRuleAssets = rules => {
  return rules.map(rule => validatePrebuiltRuleAsset(rule));
};
exports.validatePrebuiltRuleAssets = validatePrebuiltRuleAssets;
const validatePrebuiltRuleAsset = rule => {
  const decoded = _prebuilt_rule_asset.PrebuiltRuleAsset.decode(rule);
  const checked = (0, _securitysolutionIoTsUtils.exactCheck)(rule, decoded);
  const onLeft = errors => {
    const ruleName = rule.name ? rule.name : '(rule name unknown)';
    const ruleId = rule.rule_id ? rule.rule_id : '(rule rule_id unknown)';
    throw new _securitysolutionEsUtils.BadRequestError(`name: "${ruleName}", rule_id: "${ruleId}" within the security-rule saved object ` + `is not a valid detection engine rule. Expect the system ` + `to not work with pre-packaged rules until this rule is fixed ` + `or the file is removed. Error is: ${(0, _securitysolutionIoTsUtils.formatErrors)(errors).join()}, Full rule contents are:\n${JSON.stringify(rule, null, 2)}`);
  };
  return (0, _Either.getOrElse)(onLeft)(checked);
};
exports.validatePrebuiltRuleAsset = validatePrebuiltRuleAsset;