"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractTimestampOverrideObject = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractTimestampOverrideObject = rule => {
  var _rule$timestamp_overr;
  if (rule.timestamp_override == null) {
    return undefined;
  }
  return {
    field_name: rule.timestamp_override,
    fallback_disabled: (_rule$timestamp_overr = rule.timestamp_override_fallback_disabled) !== null && _rule$timestamp_overr !== void 0 ? _rule$timestamp_overr : false
  };
};
exports.extractTimestampOverrideObject = extractTimestampOverrideObject;