"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractRuleKqlQuery = exports.extractRuleEqlQuery = exports.extractInlineKqlQuery = void 0;
var _diffable_field_types = require("../../../../../../../common/detection_engine/prebuilt_rules/model/diff/diffable_rule/diffable_field_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractRuleKqlQuery = (query, language, filters, savedQueryId) => {
  if (savedQueryId != null) {
    return {
      type: _diffable_field_types.KqlQueryType.saved_query,
      saved_query_id: savedQueryId
    };
  } else {
    return extractInlineKqlQuery(query, language, filters);
  }
};
exports.extractRuleKqlQuery = extractRuleKqlQuery;
const extractInlineKqlQuery = (query, language, filters) => {
  return {
    type: _diffable_field_types.KqlQueryType.inline_query,
    query: query !== null && query !== void 0 ? query : '',
    language: language !== null && language !== void 0 ? language : 'kuery',
    filters: filters !== null && filters !== void 0 ? filters : []
  };
};
exports.extractInlineKqlQuery = extractInlineKqlQuery;
const extractRuleEqlQuery = (query, language, filters) => {
  return {
    query,
    language,
    filters: filters !== null && filters !== void 0 ? filters : []
  };
};
exports.extractRuleEqlQuery = extractRuleEqlQuery;