"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.simpleDiffAlgorithm = void 0;
var _utility_types = require("../../../../../../../../common/utility_types");
var _three_way_diff_outcome = require("../../../../../../../../common/detection_engine/prebuilt_rules/model/diff/three_way_diff/three_way_diff_outcome");
var _three_way_merge_outcome = require("../../../../../../../../common/detection_engine/prebuilt_rules/model/diff/three_way_diff/three_way_merge_outcome");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const simpleDiffAlgorithm = versions => {
  const {
    base_version: baseVersion,
    current_version: currentVersion,
    target_version: targetVersion
  } = versions;
  const diffOutcome = (0, _three_way_diff_outcome.determineDiffOutcome)(baseVersion, currentVersion, targetVersion);
  const valueCanUpdate = (0, _three_way_diff_outcome.determineIfValueCanUpdate)(diffOutcome);
  const {
    mergeOutcome,
    mergedVersion
  } = mergeVersions({
    currentVersion,
    targetVersion,
    diffOutcome
  });
  return {
    base_version: baseVersion,
    current_version: currentVersion,
    target_version: targetVersion,
    merged_version: mergedVersion,
    diff_outcome: diffOutcome,
    merge_outcome: mergeOutcome,
    has_update: valueCanUpdate,
    has_conflict: mergeOutcome === _three_way_merge_outcome.ThreeWayMergeOutcome.Conflict
  };
};
exports.simpleDiffAlgorithm = simpleDiffAlgorithm;
const mergeVersions = ({
  currentVersion,
  targetVersion,
  diffOutcome
}) => {
  switch (diffOutcome) {
    case _three_way_diff_outcome.ThreeWayDiffOutcome.StockValueNoUpdate:
    case _three_way_diff_outcome.ThreeWayDiffOutcome.CustomizedValueNoUpdate:
    case _three_way_diff_outcome.ThreeWayDiffOutcome.CustomizedValueSameUpdate:
      {
        return {
          mergeOutcome: _three_way_merge_outcome.ThreeWayMergeOutcome.Current,
          mergedVersion: currentVersion
        };
      }
    case _three_way_diff_outcome.ThreeWayDiffOutcome.StockValueCanUpdate:
      {
        return {
          mergeOutcome: _three_way_merge_outcome.ThreeWayMergeOutcome.Target,
          mergedVersion: targetVersion
        };
      }
    case _three_way_diff_outcome.ThreeWayDiffOutcome.CustomizedValueCanUpdate:
      {
        return {
          mergeOutcome: _three_way_merge_outcome.ThreeWayMergeOutcome.Conflict,
          mergedVersion: targetVersion
        };
      }
    default:
      return (0, _utility_types.assertUnreachable)(diffOutcome);
  }
};