"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reviewRuleInstallationRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _prebuilt_rules = require("../../../../../../common/detection_engine/prebuilt_rules");
var _utils = require("../../../routes/utils");
var _convert_rule_to_diffable = require("../../logic/diff/normalization/convert_rule_to_diffable");
var _prebuilt_rule_assets_client = require("../../logic/rule_assets/prebuilt_rule_assets_client");
var _prebuilt_rule_objects_client = require("../../logic/rule_objects/prebuilt_rule_objects_client");
var _get_version_buckets = require("../../model/rule_versions/get_version_buckets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reviewRuleInstallationRoute = router => {
  router.post({
    path: _prebuilt_rules.REVIEW_RULE_INSTALLATION_URL,
    validate: {},
    options: {
      tags: ['access:securitySolution']
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const ctx = await context.resolve(['core', 'alerting']);
      const soClient = ctx.core.savedObjects.client;
      const rulesClient = ctx.alerting.getRulesClient();
      const ruleAssetsClient = (0, _prebuilt_rule_assets_client.createPrebuiltRuleAssetsClient)(soClient);
      const ruleObjectsClient = (0, _prebuilt_rule_objects_client.createPrebuiltRuleObjectsClient)(rulesClient);
      const [latestVersions, {
        installedVersions
      }] = await Promise.all([ruleAssetsClient.fetchLatestVersions(), ruleObjectsClient.fetchInstalledRules()]);
      const versionBuckets = (0, _get_version_buckets.getVersionBuckets)({
        latestVersions,
        installedVersions
      });
      const rulesToInstall = await ruleAssetsClient.fetchAssetsByVersionInfo(versionBuckets.latestVersionsToInstall);
      const body = {
        status_code: 200,
        message: 'OK',
        attributes: {
          stats: calculateRuleStats(rulesToInstall),
          rules: calculateRuleInfos(rulesToInstall)
        }
      };
      return response.ok({
        body
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.reviewRuleInstallationRoute = reviewRuleInstallationRoute;
const getAggregatedTags = rules => {
  const set = new Set(rules.flatMap(rule => rule.tags || []));
  return Array.from(set.values()).sort((a, b) => a.localeCompare(b));
};
const calculateRuleStats = rulesToInstall => {
  const tagsOfRulesToInstall = getAggregatedTags(rulesToInstall);
  return {
    num_rules_to_install: rulesToInstall.length,
    tags: tagsOfRulesToInstall
  };
};
const calculateRuleInfos = rulesToInstall => {
  return rulesToInstall.map(rule => (0, _convert_rule_to_diffable.convertRuleToDiffable)(rule));
};