"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPrebuiltRulesRoutes = void 0;
var _route = require("./get_prebuilt_rules_and_timelines_status/route");
var _route2 = require("./get_prebuilt_rules_status/route");
var _route3 = require("./install_prebuilt_rules_and_timelines/route");
var _route4 = require("./generate_assets/route");
var _route5 = require("./review_rule_installation/route");
var _route6 = require("./review_rule_upgrade/route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerPrebuiltRulesRoutes = (router, config, security) => {
  const {
    prebuiltRulesNewUpgradeAndInstallationWorkflowsEnabled
  } = config.experimentalFeatures;

  // Legacy endpoints that we're going to deprecate
  (0, _route.getPrebuiltRulesAndTimelinesStatusRoute)(router, security);
  (0, _route3.installPrebuiltRulesAndTimelinesRoute)(router);
  if (prebuiltRulesNewUpgradeAndInstallationWorkflowsEnabled) {
    // New endpoints for the rule upgrade and installation workflows
    (0, _route2.getPrebuiltRulesStatusRoute)(router);
    (0, _route5.reviewRuleInstallationRoute)(router);
    (0, _route6.reviewRuleUpgradeRoute)(router);

    // Helper endpoints for development and testing. Should be removed later.
    (0, _route4.generateAssetsRoute)(router);
  }
};
exports.registerPrebuiltRulesRoutes = registerPrebuiltRulesRoutes;