"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateAssetsRoute = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _moment = _interopRequireDefault(require("moment"));
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _prebuilt_rules = require("../../../../../../common/detection_engine/prebuilt_rules");
var _route_validation = require("../../../../../utils/build_validation/route_validation");
var _utils = require("../../../routes/utils");
var _prebuilt_rule_assets_client = require("../../logic/rule_assets/prebuilt_rule_assets_client");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RequestBody = t.exact(t.type({
  num_versions_per_rule: _securitysolutionIoTsTypes.PositiveIntegerGreaterThanZero
}));

/**
 * NOTE: This is a helper endpoint for development and testing. It should be removed later.
 * This endpoint:
 *   - reads currently installed latest assets (saved objects of type security-rule)
 *   - generates more versions of rule assets based on the latest ones (multiple versions per rule)
 *   - writes the generated saved objects back to the kibana index
 */
const generateAssetsRoute = router => {
  router.post({
    path: _prebuilt_rules.GENERATE_ASSETS_URL,
    validate: {
      body: (0, _route_validation.buildRouteValidation)(RequestBody)
    },
    options: {
      tags: ['access:securitySolution'],
      timeout: {
        // FUNFACT: If we do not add a very long timeout what will happen
        // is that Chrome which receive a 408 error and then do a retry.
        // This retry can cause lots of connections to happen. Using a very
        // long timeout will ensure that Chrome does not do retries and saturate the connections.
        idleSocket: _moment.default.duration('1', 'hour').asMilliseconds()
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const ctx = await context.resolve(['core']);
      const soClient = ctx.core.savedObjects.client;
      const ruleAssetsClient = (0, _prebuilt_rule_assets_client.createPrebuiltRuleAssetsClient)(soClient);
      const latestRules = await ruleAssetsClient.fetchLatestAssets();
      const historicalRules = generateHistoricalVersionsForManyRules(latestRules, request.body.num_versions_per_rule);
      await ruleAssetsClient.bulkCreateAssets(historicalRules);
      return response.ok({
        body: {
          num_latest_rules: latestRules.length,
          num_installed_versions: historicalRules.length
        }
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.generateAssetsRoute = generateAssetsRoute;
const generateHistoricalVersionsForManyRules = (rules, numberOfVersionsPerRule) => {
  const result = [];
  rules.forEach(rule => {
    result.push(...generateHistoricalVersionsForOneRule(rule, numberOfVersionsPerRule));
  });
  return result;
};
const generateHistoricalVersionsForOneRule = (rule, numberOfVersionsPerRule) => {
  const {
    name: ruleName,
    version: latestVersion,
    ...restOfRuleAttributes
  } = rule;
  const nextToLatestVersion = latestVersion + 1;
  const result = [];
  for (let i = 0; i < numberOfVersionsPerRule; i++) {
    const historicalVersion = nextToLatestVersion + i;
    result.push({
      name: `${ruleName} v${historicalVersion}`,
      version: historicalVersion,
      ...restOfRuleAttributes
    });
  }
  return result;
};