"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findTagsByName = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findTagsByName = async ({
  savedObjectsClient,
  search
}) => {
  try {
    const tagResponse = await savedObjectsClient.find({
      type: 'tag',
      search,
      searchFields: ['name'],
      sortField: 'updated_at',
      sortOrder: 'desc'
    });
    return {
      response: tagResponse.saved_objects.filter(({
        attributes: {
          name
        }
      }) => name === search)
    };
  } catch (e) {
    return {
      error: (0, _securitysolutionEsUtils.transformError)(e),
      response: null
    };
  }
};
exports.findTagsByName = findTagsByName;