"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTag = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createTag = async ({
  savedObjectsClient,
  tagName,
  description,
  color,
  references
}) => {
  const TYPE = 'tag';
  try {
    const createdTag = await savedObjectsClient.create(TYPE, {
      name: tagName,
      description,
      color
    }, {
      references
    });
    return {
      response: createdTag
    };
  } catch (e) {
    return {
      error: (0, _securitysolutionEsUtils.transformError)(e),
      response: null
    };
  }
};
exports.createTag = createTag;