"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecuritySolutionDashboardsRoute = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _utils = require("../../detection_engine/routes/utils");
var _common = require("../../timeline/utils/common");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSecuritySolutionDashboardsRoute = (router, logger, security) => {
  router.get({
    path: _constants.INTERNAL_DASHBOARDS_URL,
    validate: false,
    options: {
      tags: ['access:securitySolution']
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, security, request);
    const savedObjectsClient = (await frameworkRequest.context.core).savedObjects.client;
    const {
      response: dashboards,
      error
    } = await (0, _helpers.getSecuritySolutionDashboards)({
      logger,
      savedObjectsClient
    });
    if (!error && dashboards != null) {
      return response.ok({
        body: dashboards
      });
    } else {
      var _error$statusCode;
      return siemResponse.error({
        statusCode: (_error$statusCode = error === null || error === void 0 ? void 0 : error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: _i18n.i18n.translate('xpack.securitySolution.dashboards.getSecuritySolutionDashboardsErrorTitle', {
          values: {
            message: error === null || error === void 0 ? void 0 : error.message
          },
          defaultMessage: `Failed to get dashboards - {message}`
        })
      });
    }
  });
};
exports.getSecuritySolutionDashboardsRoute = getSecuritySolutionDashboardsRoute;