"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecuritySolutionDashboards = exports.getOrCreateSecurityTag = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../common/constants");
var _tags = require("./saved_objects/tags");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the hex representation of a random color (e.g `#F1B7E2`)
 */
const getRandomColor = () => {
  return `#${String(Math.floor(Math.random() * 16777215).toString(16)).padStart(6, '0')}`;
};
const getOrCreateSecurityTag = async ({
  logger,
  savedObjectsClient
}) => {
  const {
    response: existingTags
  } = await (0, _tags.findTagsByName)({
    savedObjectsClient,
    search: _constants.SECURITY_TAG_NAME
  });
  if (existingTags && existingTags.length > 0) {
    return {
      response: existingTags
    };
  } else {
    const {
      error,
      response: createdTag
    } = await (0, _tags.createTag)({
      savedObjectsClient,
      tagName: _constants.SECURITY_TAG_NAME,
      description: _constants.SECURITY_TAG_DESCRIPTION,
      color: getRandomColor()
    });
    if (createdTag && !error) {
      return {
        response: [createdTag]
      };
    } else {
      logger.error(`Failed to create ${_constants.SECURITY_TAG_NAME} tag - ${JSON.stringify(error === null || error === void 0 ? void 0 : error.message)}`);
      return {
        response: null,
        error: error !== null && error !== void 0 ? error : (0, _securitysolutionEsUtils.transformError)(new Error(`Failed to create ${_constants.SECURITY_TAG_NAME} tag`))
      };
    }
  }
};
exports.getOrCreateSecurityTag = getOrCreateSecurityTag;
const getSecuritySolutionDashboards = async ({
  logger,
  savedObjectsClient
}) => {
  const {
    response: foundTags
  } = await (0, _tags.findTagsByName)({
    savedObjectsClient,
    search: _constants.SECURITY_TAG_NAME
  });
  if (!foundTags || (foundTags === null || foundTags === void 0 ? void 0 : foundTags.length) === 0) {
    return {
      response: []
    };
  }
  try {
    const dashboardsResponse = await savedObjectsClient.find({
      type: 'dashboard',
      hasReference: foundTags.map(({
        id: tagId
      }) => ({
        id: tagId,
        type: 'tag'
      }))
    });
    return {
      response: dashboardsResponse.saved_objects
    };
  } catch (e) {
    logger.error(`Failed to get SecuritySolution Dashboards - ${JSON.stringify(e === null || e === void 0 ? void 0 : e.message)}`);
    return {
      response: null,
      error: (0, _securitysolutionEsUtils.transformError)(e)
    };
  }
};
exports.getSecuritySolutionDashboards = getSecuritySolutionDashboards;