"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKibanaPrivilegesFeaturePrivileges = exports.getCasesKibanaFeature = void 0;
var _i18n = require("@kbn/i18n");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _server = require("@kbn/core/server");
var _common = require("@kbn/data-views-plugin/common");
var _common2 = require("@kbn/cases-plugin/common");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _constants = require("../common/constants");
var _saved_objects2 = require("./saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesKibanaFeature = () => {
  const casesCapabilities = (0, _common2.createUICapabilities)();
  const casesApiTags = (0, _common2.getApiTags)(_constants.APP_ID);
  return {
    id: _constants.CASES_FEATURE_ID,
    name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.linkSecuritySolutionCaseTitle', {
      defaultMessage: 'Cases'
    }),
    order: 1100,
    category: _server.DEFAULT_APP_CATEGORIES.security,
    app: [_constants.CASES_FEATURE_ID, 'kibana'],
    catalogue: [_constants.APP_ID],
    cases: [_constants.APP_ID],
    privileges: {
      all: {
        api: casesApiTags.all,
        app: [_constants.CASES_FEATURE_ID, 'kibana'],
        catalogue: [_constants.APP_ID],
        cases: {
          create: [_constants.APP_ID],
          read: [_constants.APP_ID],
          update: [_constants.APP_ID],
          push: [_constants.APP_ID]
        },
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        ui: casesCapabilities.all
      },
      read: {
        api: casesApiTags.read,
        app: [_constants.CASES_FEATURE_ID, 'kibana'],
        catalogue: [_constants.APP_ID],
        cases: {
          read: [_constants.APP_ID]
        },
        savedObject: {
          all: [],
          read: [..._saved_objects.hiddenTypes]
        },
        ui: casesCapabilities.read
      }
    },
    subFeatures: [{
      name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.deleteSubFeatureName', {
        defaultMessage: 'Delete'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          api: casesApiTags.delete,
          id: 'cases_delete',
          name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.deleteSubFeatureDetails', {
            defaultMessage: 'Delete cases and comments'
          }),
          includeIn: 'all',
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          cases: {
            delete: [_constants.APP_ID]
          },
          ui: casesCapabilities.delete
        }]
      }]
    }]
  };
};

// Same as the plugin id defined by Cloud Security Posture
exports.getCasesKibanaFeature = getCasesKibanaFeature;
const CLOUD_POSTURE_APP_ID = 'csp';
// Same as the saved-object type for rules defined by Cloud Security Posture
const CLOUD_POSTURE_SAVED_OBJECT_RULE_TYPE = 'csp_rule';
const responseActionSubFeatures = [{
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.responseActionsHistory.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Response Actions History access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.responseActionsHistory', {
    defaultMessage: 'Response Actions History'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.responseActionsHistory.description', {
    defaultMessage: 'Access the history of response actions performed on endpoints.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeActionsLogManagement`, `${_constants.APP_ID}-readActionsLogManagement`],
      id: 'actions_log_management_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeActionsLogManagement', 'readActionsLogManagement']
    }, {
      api: [`${_constants.APP_ID}-readActionsLogManagement`],
      id: 'actions_log_management_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readActionsLogManagement']
    }]
  }]
}, {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolation.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Host Isolation access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolation', {
    defaultMessage: 'Host Isolation'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolation.description', {
    defaultMessage: 'Perform the "isolate" and "release" response actions.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeHostIsolation`],
      id: 'host_isolation_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeHostIsolation']
    }]
  }]
}, {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.processOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Process Operations access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.processOperations', {
    defaultMessage: 'Process Operations'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.processOperations.description', {
    defaultMessage: 'Perform process-related response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeProcessOperations`],
      id: 'process_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeProcessOperations']
    }]
  }]
}, {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.fileOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for File Operations access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.fileOperations', {
    defaultMessage: 'File Operations'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.fileOperations.description', {
    defaultMessage: 'Perform file-related response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeFileOperations`],
      id: 'file_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeFileOperations']
    }]
  }]
}];
const subFeatures = [{
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.endpointList.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Endpoint List access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.endpointList', {
    defaultMessage: 'Endpoint List'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.endpointList.description', {
    defaultMessage: 'Displays all hosts running Elastic Defend and their relevant integration details.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeEndpointList`, `${_constants.APP_ID}-readEndpointList`],
      id: 'endpoint_list_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeEndpointList', 'readEndpointList']
    }, {
      api: [`${_constants.APP_ID}-readEndpointList`],
      id: 'endpoint_list_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readEndpointList']
    }]
  }]
}, {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.trustedApplications.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Trusted Applications access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.trustedApplications', {
    defaultMessage: 'Trusted Applications'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.trustedApplications.description', {
    defaultMessage: 'Helps mitigate conflicts with other software, usually other antivirus or endpoint security applications.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeTrustedApplications`, `${_constants.APP_ID}-readTrustedApplications`],
      id: 'trusted_applications_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeTrustedApplications', 'readTrustedApplications']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readTrustedApplications`],
      id: 'trusted_applications_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readTrustedApplications']
    }]
  }]
}, {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolationExceptions.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Host Isolation Exceptions access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolationExceptions', {
    defaultMessage: 'Host Isolation Exceptions'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.hostIsolationExceptions.description', {
    defaultMessage: 'Add specific IP addresses that isolated hosts are still allowed to communicate with, even when isolated from the rest of the network.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeHostIsolationExceptions`, `${_constants.APP_ID}-readHostIsolationExceptions`],
      id: 'host_isolation_exceptions_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeHostIsolationExceptions', 'readHostIsolationExceptions']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readHostIsolationExceptions`],
      id: 'host_isolation_exceptions_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readHostIsolationExceptions']
    }]
  }]
}, {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.blockList.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Blocklist access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.blockList', {
    defaultMessage: 'Blocklist'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.blockList.description', {
    defaultMessage: 'Extend Elastic Defend’s protection against malicious processes and protect against potentially harmful applications.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeBlocklist`, `${_constants.APP_ID}-readBlocklist`],
      id: 'blocklist_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeBlocklist', 'readBlocklist']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readBlocklist`],
      id: 'blocklist_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readBlocklist']
    }]
  }]
}, {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.eventFilters.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Event Filters access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.eventFilters', {
    defaultMessage: 'Event Filters'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.eventFilters.description', {
    defaultMessage: 'Filter out endpoint events that you do not need or want stored in Elasticsearch.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeEventFilters`, `${_constants.APP_ID}-readEventFilters`],
      id: 'event_filters_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeEventFilters', 'readEventFilters']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readEventFilters`],
      id: 'event_filters_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readEventFilters']
    }]
  }]
}, {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.policyManagement.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Policy Management access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.policyManagement', {
    defaultMessage: 'Elastic Defend Policy Management'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.policyManagement.description', {
    defaultMessage: 'Access the Elastic Defend integration policy to configure protections, event collection, and advanced policy features.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writePolicyManagement`, `${_constants.APP_ID}-readPolicyManagement`],
      id: 'policy_management_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writePolicyManagement', 'readPolicyManagement']
    }, {
      api: [`${_constants.APP_ID}-readPolicyManagement`],
      id: 'policy_management_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readPolicyManagement']
    }]
  }]
}, ...responseActionSubFeatures];

// execute operations are not available in 8.7,
// but will be available in 8.8
const executeActionSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.executeOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Execute Operations access.'
  }),
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.executeOperations', {
    defaultMessage: 'Execute Operations'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.subFeatures.executeOperations.description', {
    // TODO: Update this description before 8.8 FF
    defaultMessage: 'Perform script execution on the endpoint.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeExecuteOperations`],
      id: 'execute_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeExecuteOperations']
    }]
  }]
};
function getSubFeatures(experimentalFeatures) {
  let filteredSubFeatures = [];
  if (experimentalFeatures.endpointRbacEnabled) {
    filteredSubFeatures = subFeatures;
  } else if (experimentalFeatures.endpointRbacV1Enabled) {
    filteredSubFeatures = responseActionSubFeatures;
  }
  if (!experimentalFeatures.responseActionGetFileEnabled) {
    filteredSubFeatures = filteredSubFeatures.filter(subFeat => {
      return subFeat.name !== 'File Operations';
    });
  }

  // behind FF (planned for 8.8)
  if (experimentalFeatures.responseActionExecuteEnabled) {
    filteredSubFeatures = [...filteredSubFeatures, executeActionSubFeature];
  }
  return filteredSubFeatures;
}
const getKibanaPrivilegesFeaturePrivileges = (ruleTypes, experimentalFeatures) => ({
  id: _constants.SERVER_APP_ID,
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.linkSecuritySolutionTitle', {
    defaultMessage: 'Security'
  }),
  order: 1100,
  category: _server.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.APP_ID, CLOUD_POSTURE_APP_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: ruleTypes,
  privileges: {
    all: {
      app: [_constants.APP_ID, CLOUD_POSTURE_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'lists-all', 'lists-read', 'lists-summary', 'rac', 'cloud-security-posture-all', 'cloud-security-posture-read'],
      savedObject: {
        all: ['alert', 'exception-list', _securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC, _common.DATA_VIEW_SAVED_OBJECT_TYPE, ..._saved_objects2.savedObjectTypes, CLOUD_POSTURE_SAVED_OBJECT_RULE_TYPE],
        read: []
      },
      alerting: {
        rule: {
          all: ruleTypes
        },
        alert: {
          all: ruleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'crud']
    },
    read: {
      app: [_constants.APP_ID, CLOUD_POSTURE_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'lists-read', 'rac', 'cloud-security-posture-read'],
      savedObject: {
        all: [],
        read: ['exception-list', _securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC, _common.DATA_VIEW_SAVED_OBJECT_TYPE, ..._saved_objects2.savedObjectTypes, CLOUD_POSTURE_SAVED_OBJECT_RULE_TYPE]
      },
      alerting: {
        rule: {
          read: ruleTypes
        },
        alert: {
          all: ruleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show']
    }
  },
  subFeatures: getSubFeatures(experimentalFeatures)
});
exports.getKibanaPrivilegesFeaturePrivileges = getKibanaPrivilegesFeaturePrivileges;