"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogger = exports.getEndpointSuggestionsRequestHandler = void 0;
exports.registerEndpointSuggestionsRoutes = registerEndpointSuggestionsRoutes;
var _rxjs = require("rxjs");
var _server = require("@kbn/data-plugin/server");
var _terms_enum = require("@kbn/unified-search-plugin/server/autocomplete/terms_enum");
var _exceptionable_endpoint_event_fields = require("../../../../common/endpoint/exceptions/exceptionable_endpoint_event_fields");
var _suggestions = require("../../../../common/endpoint/schema/suggestions");
var _constants = require("../../../../common/endpoint/constants");
var _with_endpoint_authz = require("../with_endpoint_authz");
var _error_handler = require("../error_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLogger = endpointAppContext => {
  return endpointAppContext.logFactory.get('suggestions');
};
exports.getLogger = getLogger;
function registerEndpointSuggestionsRoutes(router, config$, endpointContext) {
  router.post({
    path: _constants.SUGGESTIONS_ROUTE,
    validate: _suggestions.EndpointSuggestionsSchema,
    options: {
      authRequired: true,
      tags: ['access:securitySolution']
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    any: ['canWriteEventFilters']
  }, endpointContext.logFactory.get('endpointSuggestions'), getEndpointSuggestionsRequestHandler(config$, getLogger(endpointContext))));
}
const getEndpointSuggestionsRequestHandler = (config$, logger) => {
  return async (context, request, response) => {
    const config = await (0, _rxjs.firstValueFrom)(config$);
    const {
      field: fieldName,
      query,
      filters,
      fieldMeta
    } = request.body;
    let index = '';
    if (request.params.suggestion_type === 'eventFilters') {
      if (!_exceptionable_endpoint_event_fields.EXCEPTIONABLE_ENDPOINT_EVENT_FIELDS.includes(fieldName)) {
        return response.badRequest({
          body: `Unsupported field name: ${fieldName}`
        });
      }
      index = _constants.eventsIndexPattern;
    } else {
      return response.badRequest({
        body: `Invalid suggestion_type: ${request.params.suggestion_type}`
      });
    }
    const abortSignal = (0, _server.getRequestAbortedSignal)(request.events.aborted$);
    const {
      savedObjects,
      elasticsearch
    } = await context.core;
    try {
      const body = await (0, _terms_enum.termsEnumSuggestions)(config, savedObjects.client, elasticsearch.client.asInternalUser, index, fieldName, query, filters, fieldMeta, abortSignal);
      return response.ok({
        body
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, response, error);
    }
  };
};
exports.getEndpointSuggestionsRequestHandler = getEndpointSuggestionsRequestHandler;