"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogger = void 0;
exports.getMetadataListRequestHandler = getMetadataListRequestHandler;
exports.getMetadataRequestHandler = void 0;
exports.getMetadataTransformStatsHandler = getMetadataTransformStatsHandler;
var _error_handler = require("../error_handler");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLogger = endpointAppContext => {
  return endpointAppContext.logFactory.get('metadata');
};
exports.getLogger = getLogger;
function getMetadataListRequestHandler(endpointAppContext, logger) {
  return async (context, request, response) => {
    const endpointMetadataService = endpointAppContext.service.getEndpointMetadataService();
    const fleetServices = endpointAppContext.service.getInternalFleetServices();
    const esClient = (await context.core).elasticsearch.client.asInternalUser;
    const soClient = (await context.core).savedObjects.client;
    try {
      const {
        data,
        total
      } = await endpointMetadataService.getHostMetadataList(esClient, soClient, fleetServices, request.query);
      return response.ok({
        body: {
          data,
          total,
          page: request.query.page || _constants.ENDPOINT_DEFAULT_PAGE,
          pageSize: request.query.pageSize || _constants.ENDPOINT_DEFAULT_PAGE_SIZE
        }
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, response, error);
    }
  };
}
const getMetadataRequestHandler = function (endpointAppContext, logger) {
  return async (context, request, response) => {
    const endpointMetadataService = endpointAppContext.service.getEndpointMetadataService();
    try {
      const esClient = (await context.core).elasticsearch.client;
      return response.ok({
        body: await endpointMetadataService.getEnrichedHostMetadata(esClient.asInternalUser, endpointAppContext.service.getInternalFleetServices(), request.params.id)
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, response, error);
    }
  };
};
exports.getMetadataRequestHandler = getMetadataRequestHandler;
function getMetadataTransformStatsHandler(logger) {
  return async (context, _, response) => {
    const esClient = (await context.core).elasticsearch.client.asInternalUser;
    try {
      const transformStats = await esClient.transform.getTransformStats({
        transform_id: _constants.METADATA_TRANSFORMS_PATTERN,
        allow_no_match: true
      });
      return response.ok({
        body: transformStats
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, response, error);
    }
  };
}