"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerResponseActionRoutes = registerResponseActionRoutes;
var _actions = require("../../../../common/endpoint/schema/actions");
var _constants = require("../../../../common/endpoint/constants");
var _with_endpoint_authz = require("../with_endpoint_authz");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerResponseActionRoutes(router, endpointContext) {
  const logger = endpointContext.logFactory.get('hostIsolation');

  /**
   * @deprecated use ISOLATE_HOST_ROUTE_V2 instead
   */
  router.post({
    path: _constants.ISOLATE_HOST_ROUTE,
    validate: _actions.NoParametersRequestSchema,
    options: {
      authRequired: true,
      tags: ['access:securitySolution']
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canIsolateHost']
  }, logger, redirectHandler(_constants.ISOLATE_HOST_ROUTE_V2)));

  /**
   * @deprecated use RELEASE_HOST_ROUTE instead
   */
  router.post({
    path: _constants.UNISOLATE_HOST_ROUTE,
    validate: _actions.NoParametersRequestSchema,
    options: {
      authRequired: true,
      tags: ['access:securitySolution']
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canUnIsolateHost']
  }, logger, redirectHandler(_constants.UNISOLATE_HOST_ROUTE_V2)));
  router.post({
    path: _constants.ISOLATE_HOST_ROUTE_V2,
    validate: _actions.NoParametersRequestSchema,
    options: {
      authRequired: true,
      tags: ['access:securitySolution']
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canIsolateHost']
  }, logger, responseActionRequestHandler(endpointContext, 'isolate')));
  router.post({
    path: _constants.UNISOLATE_HOST_ROUTE_V2,
    validate: _actions.NoParametersRequestSchema,
    options: {
      authRequired: true,
      tags: ['access:securitySolution']
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canUnIsolateHost']
  }, logger, responseActionRequestHandler(endpointContext, 'unisolate')));
  router.post({
    path: _constants.KILL_PROCESS_ROUTE,
    validate: _actions.KillOrSuspendProcessRequestSchema,
    options: {
      authRequired: true,
      tags: ['access:securitySolution']
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canKillProcess']
  }, logger, responseActionRequestHandler(endpointContext, 'kill-process')));
  router.post({
    path: _constants.SUSPEND_PROCESS_ROUTE,
    validate: _actions.KillOrSuspendProcessRequestSchema,
    options: {
      authRequired: true,
      tags: ['access:securitySolution']
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canSuspendProcess']
  }, logger, responseActionRequestHandler(endpointContext, 'suspend-process')));
  router.post({
    path: _constants.GET_PROCESSES_ROUTE,
    validate: _actions.NoParametersRequestSchema,
    options: {
      authRequired: true,
      tags: ['access:securitySolution']
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canGetRunningProcesses']
  }, logger, responseActionRequestHandler(endpointContext, 'running-processes')));

  // `get-file` currently behind FF
  if (endpointContext.experimentalFeatures.responseActionGetFileEnabled) {
    router.post({
      path: _constants.GET_FILE_ROUTE,
      validate: _actions.EndpointActionGetFileSchema,
      options: {
        authRequired: true,
        tags: ['access:securitySolution']
      }
    }, (0, _with_endpoint_authz.withEndpointAuthz)({
      all: ['canWriteFileOperations']
    }, logger, responseActionRequestHandler(endpointContext, 'get-file')));
  }

  // `execute` currently behind FF (planned for 8.8)
  if (endpointContext.experimentalFeatures.responseActionExecuteEnabled) {
    router.post({
      path: _constants.EXECUTE_ROUTE,
      validate: _actions.ExecuteActionRequestSchema,
      options: {
        authRequired: true,
        tags: ['access:securitySolution']
      }
    }, (0, _with_endpoint_authz.withEndpointAuthz)({
      all: ['canWriteExecuteOperations']
    }, logger, responseActionRequestHandler(endpointContext, 'execute')));
  }
}
function responseActionRequestHandler(endpointContext, command) {
  return async (context, req, res) => {
    var _endpointContext$serv;
    const user = (_endpointContext$serv = endpointContext.service.security) === null || _endpointContext$serv === void 0 ? void 0 : _endpointContext$serv.authc.getCurrentUser(req);
    const casesClient = await endpointContext.service.getCasesClient(req);
    let action;
    try {
      action = await endpointContext.service.getActionCreateService().createAction({
        ...req.body,
        command,
        user
      }, casesClient);
    } catch (err) {
      return res.customError({
        statusCode: 500,
        body: err
      });
    }
    const {
      action: actionId,
      ...data
    } = action;
    return res.ok({
      body: {
        action: actionId,
        data
      }
    });
  };
}
function redirectHandler(location) {
  return async (_context, _req, res) => {
    return res.custom({
      statusCode: 308,
      headers: {
        location
      }
    });
  };
}