"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppClientFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _client = require("./client");
var _invariant = require("../../common/utils/invariant");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AppClientFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "getSpaceId", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "kibanaBranch", void 0);
  }
  setup({
    getSpaceId,
    config,
    kibanaBranch,
    kibanaVersion
  }) {
    this.getSpaceId = getSpaceId;
    this.config = config;
    this.kibanaVersion = kibanaVersion;
    this.kibanaBranch = kibanaBranch;
  }
  create(request) {
    var _this$getSpaceId, _this$getSpaceId2;
    (0, _invariant.invariant)(this.config != null, 'Cannot create AppClient as config is not present. Did you forget to call setup()?');
    (0, _invariant.invariant)(this.kibanaVersion != null, 'Cannot create AppClient as kibanaVersion is not present. Did you forget to call setup()?');
    (0, _invariant.invariant)(this.kibanaBranch != null, 'Cannot create AppClient as kibanaBranch is not present. Did you forget to call setup()?');
    const spaceId = (_this$getSpaceId = (_this$getSpaceId2 = this.getSpaceId) === null || _this$getSpaceId2 === void 0 ? void 0 : _this$getSpaceId2.call(this, request)) !== null && _this$getSpaceId !== void 0 ? _this$getSpaceId : 'default';
    return new _client.AppClient(spaceId, this.config, this.kibanaVersion, this.kibanaBranch);
  }
}
exports.AppClientFactory = AppClientFactory;