"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineDefaults = exports.getTimelineManageDefaults = void 0;
var _timeline = require("../../../../common/types/timeline");
var _default_headers = require("../../components/timeline/body/column_headers/default_headers");
var _normalize_time_range = require("../../../common/utils/normalize_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// normalizeTimeRange uses getTimeRangeSettings which cannot be used outside Kibana context if the uiSettings is not false
const {
  from: start,
  to: end
} = (0, _normalize_time_range.normalizeTimeRange)({
  from: '',
  to: ''
}, false);
const timelineDefaults = {
  activeTab: _timeline.TimelineTabs.query,
  prevActiveTab: _timeline.TimelineTabs.query,
  columns: _default_headers.defaultHeaders,
  documentType: '',
  defaultColumns: _default_headers.defaultHeaders,
  dataProviders: [],
  dataViewId: null,
  dateRange: {
    start,
    end
  },
  description: '',
  eqlOptions: {
    eventCategoryField: 'event.category',
    tiebreakerField: '',
    timestampField: '@timestamp',
    query: '',
    size: 100
  },
  eventType: 'all',
  eventIdToNoteIds: {},
  excludedRowRendererIds: [],
  expandedDetail: {},
  highlightedDropAndProviderId: '',
  historyIds: [],
  indexNames: [],
  isFavorite: false,
  isLive: false,
  isLoading: false,
  isSaving: false,
  itemsPerPage: 25,
  itemsPerPageOptions: [10, 25, 50, 100],
  kqlMode: 'filter',
  kqlQuery: {
    filterQuery: null
  },
  loadingEventIds: [],
  resolveTimelineConfig: undefined,
  queryFields: [],
  title: '',
  timelineType: _timeline.TimelineType.default,
  templateTimelineId: null,
  templateTimelineVersion: null,
  noteIds: [],
  pinnedEventIds: {},
  pinnedEventsSaveObject: {},
  savedObjectId: null,
  selectAll: false,
  sessionViewConfig: null,
  show: false,
  sort: [{
    columnId: '@timestamp',
    columnType: 'date',
    esTypes: ['date'],
    sortDirection: 'desc'
  }],
  status: _timeline.TimelineStatus.draft,
  version: null,
  deletedEventIds: [],
  selectedEventIds: {},
  isSelectAllChecked: false,
  filters: []
};
exports.timelineDefaults = timelineDefaults;
const getTimelineManageDefaults = id => ({
  defaultColumns: _default_headers.defaultHeaders,
  documentType: '',
  selectAll: false,
  id,
  isLoading: false,
  queryFields: [],
  title: '',
  graphEventId: ''
});
exports.getTimelineManageDefaults = getTimelineManageDefaults;