"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSessionViewNavigation = exports.useSessionView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _helpers = require("../../../../helpers");
var _kibana = require("../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _timeline = require("../../../../../common/types/timeline");
var _use_detail_panel = require("../../side_panel/hooks/use_detail_panel");
var _model = require("../../../../common/store/sourcerer/model");
var _column_headers = require("../body/column_headers");
var _constants = require("../../../../../common/constants");
var _translations2 = require("../body/column_headers/translations");
var _translations3 = require("../../../../common/components/exit_full_screen/translations");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _helpers2 = require("../../../containers/helpers");
var _user_privileges = require("../../../../common/components/user_privileges");
var _timeline2 = require("../../../store/timeline");
var _defaults = require("../../../store/timeline/defaults");
var _use_selector = require("../../../../common/hooks/use_selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FullScreenButtonIcon = (0, _styledComponents.default)(_eui.EuiButtonIcon)`
  margin: 4px 0 4px 0;
`;
const NavigationComponent = ({
  fullScreen,
  globalFullScreen,
  onCloseOverlay,
  isActiveTimelines,
  timelineFullScreen,
  toggleFullScreen,
  graphEventId,
  activeTab
}) => {
  const title = () => {
    if (isActiveTimelines) {
      return activeTab === _timeline.TimelineTabs.graph ? i18n.CLOSE_ANALYZER : i18n.CLOSE_SESSION;
    } else {
      return graphEventId ? i18n.CLOSE_ANALYZER : i18n.CLOSE_SESSION;
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onCloseOverlay,
    size: "xs",
    "data-test-subj": "close-overlay"
  }, title())), isActiveTimelines === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: fullScreen ? _translations3.EXIT_FULL_SCREEN : _translations2.FULL_SCREEN
  }, /*#__PURE__*/_react.default.createElement(FullScreenButtonIcon, {
    "aria-label": (0, _column_headers.isFullScreen)({
      globalFullScreen,
      isActiveTimelines,
      timelineFullScreen
    }) ? _translations3.EXIT_FULL_SCREEN : _translations2.FULL_SCREEN,
    className: fullScreen ? _constants.FULL_SCREEN_TOGGLED_CLASS_NAME : '',
    color: fullScreen ? 'ghost' : 'primary',
    "data-test-subj": "full-screen",
    iconType: "fullScreen",
    onClick: toggleFullScreen
  }))));
};
NavigationComponent.displayName = 'NavigationComponent';
const Navigation = /*#__PURE__*/_react.default.memo(NavigationComponent);
const useSessionViewNavigation = ({
  scopeId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getScope = (0, _react.useMemo)(() => {
    if ((0, _helpers.isTimelineScope)(scopeId)) {
      return _timeline2.timelineSelectors.getTimelineByIdSelector();
    } else if ((0, _helpers.isInTableScope)(scopeId)) {
      return _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
    }
  }, [scopeId]);
  const {
    globalFullScreen,
    setGlobalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    timelineFullScreen,
    setTimelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const defaults = (0, _helpers.isTimelineScope)(scopeId) ? _defaults.timelineDefaults : _securitysolutionDataTable.tableDefaults;
  const {
    graphEventId,
    sessionViewConfig,
    activeTab,
    prevActiveTab
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _ref;
    return {
      activeTab: _defaults.timelineDefaults.activeTab,
      prevActiveTab: _defaults.timelineDefaults.prevActiveTab,
      ...((_ref = getScope && getScope(state, scopeId)) !== null && _ref !== void 0 ? _ref : defaults)
    };
  });
  const scopedActions = (0, _helpers.getScopedActions)(scopeId);
  const onCloseOverlay = (0, _react.useCallback)(() => {
    const isDataGridFullScreen = document.querySelector('.euiDataGrid--fullScreen') !== null;
    // Since EUI changes these values directly as a side effect, need to add them back on close.
    if (isDataGridFullScreen) {
      if ((0, _helpers.isActiveTimeline)(scopeId)) {
        document.body.classList.add('euiDataGrid__restrictBody');
      } else {
        document.body.classList.add(_constants.SCROLLING_DISABLED_CLASS_NAME, 'euiDataGrid__restrictBody');
      }
    } else {
      if ((0, _helpers.isActiveTimeline)(scopeId)) {
        setTimelineFullScreen(false);
      } else {
        setGlobalFullScreen(false);
      }
    }
    if ((0, _helpers.isActiveTimeline)(scopeId) === false) {
      if (scopedActions) {
        dispatch(scopedActions.updateGraphEventId({
          id: scopeId,
          graphEventId: ''
        }));
        dispatch(scopedActions.updateSessionViewConfig({
          id: scopeId,
          sessionViewConfig: null
        }));
      }
    } else {
      if (activeTab === _timeline.TimelineTabs.graph) {
        if (scopedActions) {
          dispatch(scopedActions.updateGraphEventId({
            id: scopeId,
            graphEventId: ''
          }));
        }
        if (prevActiveTab === _timeline.TimelineTabs.session && !sessionViewConfig) {
          dispatch(_timeline2.timelineActions.setActiveTabTimeline({
            id: scopeId,
            activeTab: _timeline.TimelineTabs.query
          }));
        }
      } else if (activeTab === _timeline.TimelineTabs.session) {
        if ((0, _helpers.isTimelineScope)(scopeId)) {
          if (prevActiveTab === _timeline.TimelineTabs.graph && !graphEventId) {
            dispatch(_timeline2.timelineActions.setActiveTabTimeline({
              id: scopeId,
              activeTab: _timeline.TimelineTabs.query
            }));
          } else {
            dispatch(_timeline2.timelineActions.setActiveTabTimeline({
              id: scopeId,
              activeTab: prevActiveTab
            }));
          }
        }
        if (scopedActions) {
          dispatch(scopedActions.updateSessionViewConfig({
            id: scopeId,
            sessionViewConfig: null
          }));
        }
      }
    }
  }, [setTimelineFullScreen, setGlobalFullScreen, scopedActions, dispatch, scopeId, activeTab, prevActiveTab, sessionViewConfig, graphEventId]);
  const fullScreen = (0, _react.useMemo)(() => (0, _column_headers.isFullScreen)({
    globalFullScreen,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId),
    timelineFullScreen
  }), [globalFullScreen, scopeId, timelineFullScreen]);
  const toggleFullScreen = (0, _react.useCallback)(() => {
    if ((0, _helpers.isActiveTimeline)(scopeId)) {
      setTimelineFullScreen(!timelineFullScreen);
    } else {
      setGlobalFullScreen(!globalFullScreen);
    }
  }, [scopeId, setTimelineFullScreen, timelineFullScreen, setGlobalFullScreen, globalFullScreen]);
  const navigation = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(Navigation, {
      fullScreen: fullScreen,
      globalFullScreen: globalFullScreen,
      activeTab: activeTab,
      onCloseOverlay: onCloseOverlay,
      isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId),
      timelineFullScreen: timelineFullScreen,
      toggleFullScreen: toggleFullScreen,
      graphEventId: graphEventId
    });
  }, [fullScreen, globalFullScreen, activeTab, onCloseOverlay, scopeId, timelineFullScreen, toggleFullScreen, graphEventId]);
  return {
    onCloseOverlay,
    Navigation: navigation
  };
};
exports.useSessionViewNavigation = useSessionViewNavigation;
const useSessionView = ({
  scopeId,
  entityType,
  height
}) => {
  const {
    sessionView
  } = (0, _kibana.useKibana)().services;
  const getScope = (0, _react.useMemo)(() => {
    if ((0, _helpers.isTimelineScope)(scopeId)) {
      return _timeline2.timelineSelectors.getTimelineByIdSelector();
    } else if ((0, _helpers.isInTableScope)(scopeId)) {
      return _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
    }
  }, [scopeId]);
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    timelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const {
    canAccessEndpointManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const defaults = (0, _helpers.isTimelineScope)(scopeId) ? _defaults.timelineDefaults : _securitysolutionDataTable.tableDefaults;
  const {
    sessionViewConfig,
    activeTab
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _ref2;
    return {
      activeTab: _defaults.timelineDefaults.activeTab,
      prevActiveTab: _defaults.timelineDefaults.prevActiveTab,
      ...((_ref2 = getScope && getScope(state, scopeId)) !== null && _ref2 !== void 0 ? _ref2 : defaults)
    };
  });
  const fullScreen = (0, _react.useMemo)(() => (0, _column_headers.isFullScreen)({
    globalFullScreen,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId),
    timelineFullScreen
  }), [globalFullScreen, scopeId, timelineFullScreen]);
  const sourcererScope = (0, _react.useMemo)(() => {
    if ((0, _helpers.isActiveTimeline)(scopeId)) {
      return _model.SourcererScopeName.timeline;
    } else if (_helpers2.detectionsTimelineIds.includes(scopeId)) {
      return _model.SourcererScopeName.detections;
    } else {
      return _model.SourcererScopeName.default;
    }
  }, [scopeId]);
  const {
    openEventDetailsPanel,
    shouldShowDetailsPanel,
    DetailsPanel
  } = (0, _use_detail_panel.useDetailPanel)({
    isFlyoutView: !(0, _helpers.isActiveTimeline)(scopeId),
    entityType,
    sourcererScope,
    scopeId,
    tabType: (0, _helpers.isActiveTimeline)(scopeId) ? activeTab : _timeline.TimelineTabs.query
  });
  const sessionViewComponent = (0, _react.useMemo)(() => {
    const sessionViewSearchBarHeight = 118;
    const heightMinusSearchBar = height ? height - sessionViewSearchBarHeight : undefined;
    return sessionViewConfig !== null ? sessionView.getSessionView({
      ...sessionViewConfig,
      loadAlertDetails: openEventDetailsPanel,
      isFullScreen: fullScreen,
      height: heightMinusSearchBar,
      canAccessEndpointManagement
    }) : null;
  }, [height, sessionViewConfig, sessionView, openEventDetailsPanel, fullScreen, canAccessEndpointManagement]);
  return {
    openEventDetailsPanel,
    shouldShowDetailsPanel,
    SessionView: sessionViewComponent,
    DetailsPanel
  };
};
exports.useSessionView = useSessionView;