"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchOrFilter = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _query_bar = require("../query_bar");
var _super_select = require("./super_select");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timelineSelectModeItemsClassName = 'timelineSelectModeItemsClassName';
const searchOrFilterPopoverClassName = 'searchOrFilterPopover';
const searchOrFilterPopoverWidth = '352px';

// SIDE EFFECT: the following creates a global class selector
const SearchOrFilterGlobalStyle = (0, _styledComponents.createGlobalStyle)`
  .${timelineSelectModeItemsClassName} {
    width: 350px !important;
  }

  .${searchOrFilterPopoverClassName}.euiPopover__panel {
    width: ${searchOrFilterPopoverWidth} !important;

    .euiSuperSelect__listbox {
      width: ${searchOrFilterPopoverWidth} !important;
    }
  }
`;
const SearchOrFilterContainer = _styledComponents.default.div`
  ${({
  theme
}) => `margin-top: ${theme.eui.euiSizeXS};`}
  user-select: none; // This should not be here, it makes the entire page inaccessible
`;
SearchOrFilterContainer.displayName = 'SearchOrFilterContainer';
const ModeFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  user-select: none; // Again, why?
`;
ModeFlexItem.displayName = 'ModeFlexItem';
const SearchOrFilter = /*#__PURE__*/_react.default.memo(({
  dataProviders,
  isRefreshPaused,
  filters,
  filterManager,
  filterQuery,
  from,
  fromStr,
  kqlMode,
  timelineId,
  refreshInterval,
  savedQueryId,
  setFilters,
  setSavedQueryId,
  to,
  toStr,
  updateKqlMode,
  updateReduxTime
}) => {
  const handleChange = (0, _react.useCallback)(mode => updateKqlMode({
    id: timelineId,
    kqlMode: mode
  }), [timelineId, updateKqlMode]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SearchOrFilterContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "timeline-search-or-filter",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(ModeFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.FILTER_OR_SEARCH_WITH_KQL
  }, /*#__PURE__*/_react.default.createElement(_super_select.EuiSuperSelect, {
    "data-test-subj": "timeline-select-search-or-filter",
    hasDividers: true,
    itemLayoutAlign: "top",
    itemClassName: timelineSelectModeItemsClassName,
    onChange: handleChange,
    options: _helpers.options,
    popoverProps: {
      className: searchOrFilterPopoverClassName
    },
    valueOfSelected: kqlMode
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "timeline-search-or-filter-search-container"
  }, /*#__PURE__*/_react.default.createElement(_query_bar.QueryBarTimeline, {
    dataProviders: dataProviders,
    filters: filters,
    filterManager: filterManager,
    filterQuery: filterQuery,
    from: from,
    fromStr: fromStr,
    kqlMode: kqlMode,
    isRefreshPaused: isRefreshPaused,
    refreshInterval: refreshInterval,
    savedQueryId: savedQueryId,
    setFilters: setFilters,
    setSavedQueryId: setSavedQueryId,
    timelineId: timelineId,
    to: to,
    toStr: toStr,
    updateReduxTime: updateReduxTime
  })))), /*#__PURE__*/_react.default.createElement(SearchOrFilterGlobalStyle, null));
});
exports.SearchOrFilter = SearchOrFilter;
SearchOrFilter.displayName = 'SearchOrFilter';