"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.QueryTabContentComponent = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactReversePortal = require("react-reverse-portal");
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _constants = require("../../../../common/store/inputs/constants");
var _use_invalid_filter_query = require("../../../../common/hooks/use_invalid_filter_query");
var _timeline = require("../../../store/timeline");
var _containers = require("../../../containers");
var _kibana = require("../../../../common/lib/kibana");
var _default_headers = require("../body/column_headers/default_headers");
var _body = require("../body");
var _footer = require("../footer");
var _header = require("../header");
var _helpers = require("../helpers");
var _kuery = require("../../../../common/lib/kuery");
var _refetch_timeline = require("../refetch_timeline");
var _timeline2 = require("../../../../../common/types/timeline");
var _default_config = require("../../../../detections/components/alerts_table/default_config");
var _super_date_picker = require("../../../../common/components/super_date_picker");
var _event_details_width_context = require("../../../../common/components/events_viewer/event_details_width_context");
var _store = require("../../../../common/store");
var _model = require("../../../../common/store/sourcerer/model");
var _defaults = require("../../../store/timeline/defaults");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_timeline_events_count = require("../../../../common/hooks/use_timeline_events_count");
var _date_picker_lock = require("../date_picker_lock");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _active_timeline_context = require("../../../containers/active_timeline_context");
var _side_panel = require("../../side_panel");
var _exit_full_screen = require("../../../../common/components/exit_full_screen");
var _control_columns = require("../body/control_columns");
var _use_selector = require("../../../../common/hooks/use_selector");
var _sourcerer2 = require("../../../../common/components/sourcerer");
var _use_license = require("../../../../common/hooks/use_license");
var _header_actions = require("../../../../common/components/header_actions/header_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelineHeaderContainer = _styledComponents.default.div`
  margin-top: 6px;
  width: 100%;
`;
TimelineHeaderContainer.displayName = 'TimelineHeaderContainer';
const StyledEuiFlyoutHeader = (0, _styledComponents.default)(_eui.EuiFlyoutHeader)`
  align-items: stretch;
  box-shadow: none;
  display: flex;
  flex-direction: column;

  &.euiFlyoutHeader {
    ${({
  theme
}) => `padding: ${theme.eui.euiSizeM} ${theme.eui.euiSizeS} 0 ${theme.eui.euiSizeS};`}
  }
`;
const StyledEuiFlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  overflow-y: hidden;
  flex: 1;

  .euiFlyoutBody__overflow {
    overflow: hidden;
    mask-image: none;
  }

  .euiFlyoutBody__overflowContent {
    padding: 0;
    height: 100%;
    display: flex;
  }
`;
const StyledEuiFlyoutFooter = (0, _styledComponents.default)(_eui.EuiFlyoutFooter)`
  background: none;
  &.euiFlyoutFooter {
    ${({
  theme
}) => `padding: ${theme.eui.euiSizeS} 0;`}
  }
`;
const FullWidthFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin: 0;
  width: 100%;
  overflow: hidden;
`;
const ScrollableFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  ${({
  theme
}) => `margin: 0 ${theme.eui.euiSizeM};`}
  overflow: hidden;
`;
const DatePicker = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  .euiSuperDatePicker__flexWrapper {
    max-width: none;
    width: auto;
  }
`;
DatePicker.displayName = 'DatePicker';
const SourcererFlex = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  align-items: flex-end;
`;
SourcererFlex.displayName = 'SourcererFlex';
const VerticalRule = _styledComponents.default.div`
  width: 2px;
  height: 100%;
  background: ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
VerticalRule.displayName = 'VerticalRule';
const EventsCountBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const isTimerangeSame = (prevProps, nextProps) => prevProps.end === nextProps.end && prevProps.start === nextProps.start && prevProps.timerangeKind === nextProps.timerangeKind;
const compareQueryProps = (prevProps, nextProps) => prevProps.kqlMode === nextProps.kqlMode && prevProps.kqlQueryExpression === nextProps.kqlQueryExpression && (0, _fastDeepEqual.default)(prevProps.filters, nextProps.filters);
const EMPTY_EVENTS = [];
const trailingControlColumns = []; // stable reference

const QueryTabContentComponent = ({
  activeTab,
  columns,
  dataProviders,
  end,
  expandedDetail,
  filters,
  timelineId,
  isLive,
  itemsPerPage,
  itemsPerPageOptions,
  kqlMode,
  kqlQueryExpression,
  kqlQueryLanguage,
  onEventClosed,
  renderCellValue,
  rowRenderers,
  show,
  showCallOutUnauthorizedMsg,
  showExpandedDetails,
  start,
  status,
  sort,
  timerangeKind
}) => {
  var _pageInfo$activePage;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    portalNode: timelineEventsCountPortalNode
  } = (0, _use_timeline_events_count.useTimelineEventsCountPortal)();
  const {
    setTimelineFullScreen,
    timelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const {
    browserFields,
    dataViewId,
    loading: loadingSourcerer,
    indexPattern,
    runtimeMappings,
    // important to get selectedPatterns from useSourcererDataView
    // in order to include the exclude filters in the search that are not stored in the timeline
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const ACTION_BUTTON_COUNT = isEnterprisePlus ? 6 : 5;
  const getManageTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const currentTimeline = (0, _use_selector.useDeepEqualSelector)(state => getManageTimeline(state, timelineId !== null && timelineId !== void 0 ? timelineId : _timeline2.TimelineId.active));
  const activeFilterManager = currentTimeline.filterManager;
  const filterManager = (0, _react.useMemo)(() => activeFilterManager !== null && activeFilterManager !== void 0 ? activeFilterManager : new _public.FilterManager(uiSettings), [activeFilterManager, uiSettings]);
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const kqlQuery = (0, _react.useMemo)(() => ({
    query: kqlQueryExpression.trim(),
    language: kqlQueryLanguage
  }), [kqlQueryExpression, kqlQueryLanguage]);
  const combinedQueries = (0, _kuery.combineQueries)({
    config: esQueryConfig,
    dataProviders,
    indexPattern,
    browserFields,
    filters,
    kqlQuery,
    kqlMode
  });
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: timelineId,
    filterQuery: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery,
    kqlError: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.kqlError,
    query: kqlQuery,
    startDate: start,
    endDate: end
  });
  const isBlankTimeline = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)(filters) && (0, _fp.isEmpty)(kqlQuery.query) && (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) === undefined;
  const canQueryTimeline = (0, _react.useMemo)(() => combinedQueries != null && loadingSourcerer != null && !loadingSourcerer && !(0, _fp.isEmpty)(start) && !(0, _fp.isEmpty)(end) && (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) !== undefined, [combinedQueries, end, loadingSourcerer, start]);
  const getTimelineQueryFields = () => {
    const columnsHeader = (0, _fp.isEmpty)(columns) ? _default_headers.defaultHeaders : columns;
    const columnFields = columnsHeader.map(c => c.id);
    return [...columnFields, ..._default_config.requiredFieldsForActions];
  };
  const timelineQuerySortField = sort.map(({
    columnId,
    columnType,
    esTypes,
    sortDirection
  }) => ({
    field: columnId,
    direction: sortDirection,
    esTypes: esTypes !== null && esTypes !== void 0 ? esTypes : [],
    type: columnType
  }));
  (0, _react.useEffect)(() => {
    dispatch(_timeline.timelineActions.initializeTimelineSettings({
      filterManager,
      id: timelineId
    }));
  }, [activeFilterManager, currentTimeline, dispatch, filterManager, timelineId, uiSettings]);
  const [isQueryLoading, {
    events,
    inspect,
    totalCount,
    pageInfo,
    loadPage,
    updatedAt,
    refetch
  }] = (0, _containers.useTimelineEvents)({
    dataViewId,
    endDate: end,
    fields: getTimelineQueryFields(),
    filterQuery: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery,
    id: timelineId,
    indexNames: selectedPatterns,
    language: kqlQuery.language,
    limit: itemsPerPage,
    runtimeMappings,
    skip: !canQueryTimeline,
    sort: timelineQuerySortField,
    startDate: start,
    timerangeKind
  });
  const handleOnPanelClosed = (0, _react.useCallback)(() => {
    var _expandedDetail$Timel;
    onEventClosed({
      tabType: _timeline2.TimelineTabs.query,
      id: timelineId
    });
    if ((_expandedDetail$Timel = expandedDetail[_timeline2.TimelineTabs.query]) !== null && _expandedDetail$Timel !== void 0 && _expandedDetail$Timel.panelView && timelineId === _timeline2.TimelineId.active && showExpandedDetails) {
      _active_timeline_context.activeTimeline.toggleExpandedDetail({});
    }
  }, [onEventClosed, timelineId, expandedDetail, showExpandedDetails]);
  (0, _react.useEffect)(() => {
    dispatch(_timeline.timelineActions.updateIsLoading({
      id: timelineId,
      isLoading: isQueryLoading || loadingSourcerer
    }));
  }, [loadingSourcerer, timelineId, isQueryLoading, dispatch]);
  const isDatePickerDisabled = (0, _react.useMemo)(() => {
    return combinedQueries && combinedQueries.kqlError != null || false;
  }, [combinedQueries]);
  const leadingControlColumns = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(ACTION_BUTTON_COUNT).map(x => ({
    ...x,
    headerCellRender: _header_actions.HeaderActions
  })), [ACTION_BUTTON_COUNT]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: timelineEventsCountPortalNode
  }, totalCount >= 0 ? /*#__PURE__*/_react.default.createElement(EventsCountBadge, null, totalCount) : null), /*#__PURE__*/_react.default.createElement(_refetch_timeline.TimelineRefetch, {
    id: `${timelineId}-${_timeline2.TimelineTabs.query}`,
    inputId: _constants.InputsModelId.timeline,
    inspect: inspect,
    loading: isQueryLoading,
    refetch: refetch,
    skip: !canQueryTimeline
  }), /*#__PURE__*/_react.default.createElement(FullWidthFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(ScrollableFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(StyledEuiFlyoutHeader, {
    "data-test-subj": `${activeTab}-tab-flyout-header`,
    hasBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    "data-test-subj": "timeline-date-picker-container"
  }, timelineFullScreen && setTimelineFullScreen != null && /*#__PURE__*/_react.default.createElement(_exit_full_screen.ExitFullScreen, {
    fullScreen: timelineFullScreen,
    setFullScreen: setTimelineFullScreen
  }), /*#__PURE__*/_react.default.createElement(DatePicker, {
    grow: 10
  }, /*#__PURE__*/_react.default.createElement(_super_date_picker.SuperDatePicker, {
    id: _constants.InputsModelId.timeline,
    timelineId: timelineId,
    disabled: isDatePickerDisabled
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_date_picker_lock.TimelineDatePickerLock, null)), /*#__PURE__*/_react.default.createElement(SourcererFlex, {
    grow: 1
  }, activeTab === _timeline2.TimelineTabs.query && /*#__PURE__*/_react.default.createElement(_sourcerer2.Sourcerer, {
    scope: _model.SourcererScopeName.timeline
  }))), /*#__PURE__*/_react.default.createElement(TimelineHeaderContainer, {
    "data-test-subj": "timelineHeader"
  }, /*#__PURE__*/_react.default.createElement(_header.TimelineHeader, {
    filterManager: filterManager,
    show: show && activeTab === _timeline2.TimelineTabs.query,
    showCallOutUnauthorizedMsg: showCallOutUnauthorizedMsg,
    status: status,
    timelineId: timelineId
  }))), /*#__PURE__*/_react.default.createElement(_event_details_width_context.EventDetailsWidthProvider, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlyoutBody, {
    "data-test-subj": `${_timeline2.TimelineTabs.query}-tab-flyout-body`,
    className: "timeline-flyout-body"
  }, /*#__PURE__*/_react.default.createElement(_body.StatefulBody, {
    activePage: pageInfo.activePage,
    browserFields: browserFields,
    data: isBlankTimeline ? EMPTY_EVENTS : events,
    id: timelineId,
    refetch: refetch,
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    sort: sort,
    tabType: _timeline2.TimelineTabs.query,
    totalPages: (0, _helpers.calculateTotalPages)({
      itemsCount: totalCount,
      itemsPerPage
    }),
    leadingControlColumns: leadingControlColumns,
    trailingControlColumns: trailingControlColumns
  })), /*#__PURE__*/_react.default.createElement(StyledEuiFlyoutFooter, {
    "data-test-subj": `${_timeline2.TimelineTabs.query}-tab-flyout-footer`,
    className: "timeline-flyout-footer"
  }, !isBlankTimeline && /*#__PURE__*/_react.default.createElement(_footer.Footer, {
    activePage: (_pageInfo$activePage = pageInfo === null || pageInfo === void 0 ? void 0 : pageInfo.activePage) !== null && _pageInfo$activePage !== void 0 ? _pageInfo$activePage : 0,
    "data-test-subj": "timeline-footer",
    updatedAt: updatedAt,
    height: _footer.footerHeight,
    id: timelineId,
    isLive: isLive,
    isLoading: isQueryLoading || loadingSourcerer,
    itemsCount: isBlankTimeline ? 0 : events.length,
    itemsPerPage: itemsPerPage,
    itemsPerPageOptions: itemsPerPageOptions,
    onChangePage: loadPage,
    totalCount: isBlankTimeline ? 0 : totalCount
  })))), showExpandedDetails && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(VerticalRule, null), /*#__PURE__*/_react.default.createElement(ScrollableFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_side_panel.DetailsPanel, {
    browserFields: browserFields,
    handleOnPanelClosed: handleOnPanelClosed,
    runtimeMappings: runtimeMappings,
    tabType: _timeline2.TimelineTabs.query,
    scopeId: timelineId
  })))));
};
exports.QueryTabContentComponent = QueryTabContentComponent;
const makeMapStateToProps = () => {
  const getShowCallOutUnauthorizedMsg = _timeline.timelineSelectors.getShowCallOutUnauthorizedMsg();
  const getTimeline = _timeline.timelineSelectors.getTimelineByIdSelector();
  const getKqlQueryTimeline = _timeline.timelineSelectors.getKqlFilterKuerySelector();
  const getInputsTimeline = _store.inputsSelectors.getTimelineSelector();
  const mapStateToProps = (state, {
    timelineId
  }) => {
    var _getTimeline, _kqlQueryTimeline$exp, _kqlQueryTimeline$exp2, _kqlQueryTimeline$kin, _expandedDetail$Timel2;
    const timeline = (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
    const input = getInputsTimeline(state);
    const {
      activeTab,
      columns,
      dataProviders,
      expandedDetail,
      filters,
      itemsPerPage,
      itemsPerPageOptions,
      kqlMode,
      show,
      sort,
      status,
      timelineType
    } = timeline;
    const kqlQueryTimeline = getKqlQueryTimeline(state, timelineId);
    const timelineFilter = kqlMode === 'filter' ? filters || [] : [];

    // return events on empty search
    const kqlQueryExpression = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)((_kqlQueryTimeline$exp = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.expression) !== null && _kqlQueryTimeline$exp !== void 0 ? _kqlQueryTimeline$exp : '') && timelineType === 'template' ? ' ' : (_kqlQueryTimeline$exp2 = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.expression) !== null && _kqlQueryTimeline$exp2 !== void 0 ? _kqlQueryTimeline$exp2 : '';
    const kqlQueryLanguage = (0, _fp.isEmpty)(dataProviders) && timelineType === 'template' ? 'kuery' : (_kqlQueryTimeline$kin = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.kind) !== null && _kqlQueryTimeline$kin !== void 0 ? _kqlQueryTimeline$kin : 'kuery';
    return {
      activeTab,
      columns,
      dataProviders,
      end: input.timerange.to,
      expandedDetail,
      filters: timelineFilter,
      timelineId,
      isLive: input.policy.kind === 'interval',
      itemsPerPage,
      itemsPerPageOptions,
      kqlMode,
      kqlQueryExpression,
      kqlQueryLanguage,
      showCallOutUnauthorizedMsg: getShowCallOutUnauthorizedMsg(state),
      show,
      showExpandedDetails: !!expandedDetail[_timeline2.TimelineTabs.query] && !!((_expandedDetail$Timel2 = expandedDetail[_timeline2.TimelineTabs.query]) !== null && _expandedDetail$Timel2 !== void 0 && _expandedDetail$Timel2.panelView),
      sort,
      start: input.timerange.from,
      status,
      timerangeKind: input.timerange.kind
    };
  };
  return mapStateToProps;
};
const mapDispatchToProps = (dispatch, {
  timelineId
}) => ({
  onEventClosed: args => {
    dispatch(_timeline.timelineActions.toggleDetailPanel(args));
  }
});
const connector = (0, _reactRedux.connect)(makeMapStateToProps, mapDispatchToProps);
const QueryTabContent = connector( /*#__PURE__*/_react.default.memo(QueryTabContentComponent, (prevProps, nextProps) => compareQueryProps(prevProps, nextProps) && prevProps.activeTab === nextProps.activeTab && isTimerangeSame(prevProps, nextProps) && prevProps.isLive === nextProps.isLive && prevProps.itemsPerPage === nextProps.itemsPerPage && prevProps.onEventClosed === nextProps.onEventClosed && prevProps.show === nextProps.show && prevProps.showCallOutUnauthorizedMsg === nextProps.showCallOutUnauthorizedMsg && prevProps.showExpandedDetails === nextProps.showExpandedDetails && prevProps.status === nextProps.status && prevProps.timelineId === nextProps.timelineId && (0, _fastDeepEqual.default)(prevProps.columns, nextProps.columns) && (0, _fastDeepEqual.default)(prevProps.dataProviders, nextProps.dataProviders) && (0, _fastDeepEqual.default)(prevProps.itemsPerPageOptions, nextProps.itemsPerPageOptions) && (0, _fastDeepEqual.default)(prevProps.sort, nextProps.sort)));

// eslint-disable-next-line import/no-default-export
exports.default = QueryTabContent;