"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataProviderFilter = exports.TIMELINE_FILTER_DROP_AREA = exports.QueryBarTimeline = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _esQuery = require("@kbn/es-query");
var _constants = require("../../../../common/store/inputs/constants");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _model = require("../../../../common/store/sourcerer/model");
var _kuery = require("../../../../common/lib/kuery");
var _saved_query_services = require("../../../../common/utils/saved_query_services");
var _query_bar = require("../../../../common/components/query_bar");
var _helpers = require("../helpers");
var _timeline = require("../../../store/timeline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIMELINE_FILTER_DROP_AREA = 'timeline-filter-drop-area';
exports.TIMELINE_FILTER_DROP_AREA = TIMELINE_FILTER_DROP_AREA;
const getNonDropAreaFilters = (filters = []) => filters.filter(f => f.meta.controlledBy !== TIMELINE_FILTER_DROP_AREA);
const QueryBarTimeline = /*#__PURE__*/(0, _react.memo)(({
  dataProviders,
  filters,
  filterManager,
  filterQuery,
  from,
  fromStr,
  kqlMode,
  isRefreshPaused,
  savedQueryId,
  setFilters,
  setSavedQueryId,
  refreshInterval,
  timelineId,
  to,
  toStr,
  updateReduxTime
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [dateRangeFrom, setDateRangeFrom] = (0, _react.useState)(fromStr != null ? fromStr : new Date(from).toISOString());
  const [dateRangeTo, setDateRangTo] = (0, _react.useState)(toStr != null ? toStr : new Date(to).toISOString());
  const {
    browserFields,
    indexPattern
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const [savedQuery, setSavedQuery] = (0, _react.useState)(undefined);
  const [filterQueryConverted, setFilterQueryConverted] = (0, _react.useState)({
    query: filterQuery != null ? filterQuery.expression : '',
    language: filterQuery != null ? filterQuery.kind : 'kuery'
  });
  const [queryBarFilters, setQueryBarFilters] = (0, _react.useState)(getNonDropAreaFilters(filters));
  const [dataProvidersDsl, setDataProvidersDsl] = (0, _react.useState)((0, _kuery.convertKueryToElasticSearchQuery)((0, _helpers.buildGlobalQuery)(dataProviders, browserFields), indexPattern));
  const savedQueryServices = (0, _saved_query_services.useSavedQueryServices)();
  const applyKqlFilterQuery = (0, _react.useCallback)((expression, kind) => dispatch(_timeline.timelineActions.applyKqlFilterQuery({
    id: timelineId,
    filterQuery: {
      kuery: {
        kind,
        expression
      },
      serializedQuery: (0, _kuery.convertKueryToElasticSearchQuery)(expression, indexPattern)
    }
  })), [dispatch, indexPattern, timelineId]);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const subscriptions = new _rxjs.Subscription();
    filterManager.setFilters(filters);
    subscriptions.add(filterManager.getUpdates$().subscribe({
      next: () => {
        if (isSubscribed) {
          const filterWithoutDropArea = getNonDropAreaFilters(filterManager.getFilters());
          setFilters(filterWithoutDropArea);
          setQueryBarFilters(filterWithoutDropArea);
        }
      }
    }));
    return () => {
      isSubscribed = false;
      subscriptions.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    const filterWithoutDropArea = getNonDropAreaFilters(filterManager.getFilters());
    if (!(0, _fastDeepEqual.default)(filters, filterWithoutDropArea)) {
      filterManager.setFilters(filters);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [filters]);
  (0, _react.useEffect)(() => {
    setFilterQueryConverted({
      query: filterQuery != null ? filterQuery.expression : '',
      language: filterQuery != null ? filterQuery.kind : 'kuery'
    });
  }, [filterQuery]);
  (0, _react.useEffect)(() => {
    setDataProvidersDsl((0, _kuery.convertKueryToElasticSearchQuery)((0, _helpers.buildGlobalQuery)(dataProviders, browserFields), indexPattern));
  }, [dataProviders, browserFields, indexPattern]);
  (0, _react.useEffect)(() => {
    if (fromStr != null && toStr != null) {
      setDateRangeFrom(fromStr);
      setDateRangTo(toStr);
    } else if (from != null && to != null) {
      setDateRangeFrom(new Date(from).toISOString());
      setDateRangTo(new Date(to).toISOString());
    }
  }, [from, fromStr, to, toStr]);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    async function setSavedQueryByServices() {
      if (savedQueryId != null && savedQueryServices != null) {
        try {
          // The getSavedQuery function will throw a promise rejection in
          // src/legacy/core_plugins/data/public/search/search_bar/lib/saved_query_service.ts
          // if the savedObjectsClient is undefined. This is happening in a test
          // so I wrapped this in a try catch to keep the unhandled promise rejection
          // warning from appearing in tests.
          const mySavedQuery = await savedQueryServices.getSavedQuery(savedQueryId);
          if (isSubscribed && mySavedQuery != null) {
            setSavedQuery({
              ...mySavedQuery,
              attributes: {
                ...mySavedQuery.attributes,
                filters: getNonDropAreaFilters(filters)
              }
            });
          }
        } catch (exc) {
          setSavedQuery(undefined);
        }
      } else if (isSubscribed) {
        setSavedQuery(undefined);
      }
    }
    setSavedQueryByServices();
    return () => {
      isSubscribed = false;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [savedQueryId]);
  const onSubmitQuery = (0, _react.useCallback)((newQuery, timefilter) => {
    if (filterQuery == null || filterQuery != null && filterQuery.expression !== newQuery.query || filterQuery.kind !== newQuery.language) {
      applyKqlFilterQuery(newQuery.query, newQuery.language);
    }
    if (timefilter != null) {
      const isQuickSelection = timefilter.from.includes('now') || timefilter.to.includes('now');
      updateReduxTime({
        id: _constants.InputsModelId.timeline,
        end: timefilter.to,
        start: timefilter.from,
        isInvalid: false,
        isQuickSelection,
        timelineId
      });
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [filterQuery, timelineId]);
  const onSavedQuery = (0, _react.useCallback)(newSavedQuery => {
    if (newSavedQuery != null) {
      if (newSavedQuery.id !== savedQueryId) {
        setSavedQueryId(newSavedQuery.id);
      }
      if (savedQueryServices != null && dataProvidersDsl !== '') {
        const dataProviderFilterExists = newSavedQuery.attributes.filters != null ? newSavedQuery.attributes.filters.findIndex(f => f.meta.controlledBy === TIMELINE_FILTER_DROP_AREA) : -1;
        savedQueryServices.updateQuery(newSavedQuery.id, {
          ...newSavedQuery.attributes,
          filters: newSavedQuery.attributes.filters != null ? dataProviderFilterExists > -1 ? [...newSavedQuery.attributes.filters.slice(0, dataProviderFilterExists), getDataProviderFilter(dataProvidersDsl), ...newSavedQuery.attributes.filters.slice(dataProviderFilterExists + 1)] : [...newSavedQuery.attributes.filters, getDataProviderFilter(dataProvidersDsl)] : []
        });
      }
    } else {
      setSavedQueryId(null);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [dataProvidersDsl, savedQueryId, savedQueryServices]);
  return /*#__PURE__*/_react.default.createElement(_query_bar.QueryBar, {
    dateRangeFrom: dateRangeFrom,
    dateRangeTo: dateRangeTo,
    hideSavedQuery: kqlMode === 'search',
    indexPattern: indexPattern,
    isRefreshPaused: isRefreshPaused,
    filterQuery: filterQueryConverted,
    filterManager: filterManager,
    filters: queryBarFilters,
    onSubmitQuery: onSubmitQuery,
    refreshInterval: refreshInterval,
    savedQuery: savedQuery,
    onSavedQuery: onSavedQuery,
    dataTestSubj: 'timelineQueryInput',
    displayStyle: "inPage"
  });
});
exports.QueryBarTimeline = QueryBarTimeline;
const getDataProviderFilter = dataProviderDsl => {
  const dslObject = JSON.parse(dataProviderDsl);
  const key = Object.keys(dslObject);
  return {
    ...dslObject,
    meta: {
      alias: TIMELINE_FILTER_DROP_AREA,
      controlledBy: TIMELINE_FILTER_DROP_AREA,
      negate: false,
      disabled: false,
      type: 'custom',
      key: (0, _fp.isEmpty)(key) ? 'bool' : key[0],
      value: dataProviderDsl
    },
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    }
  };
};
exports.getDataProviderFilter = getDataProviderFilter;