"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateTimelineButton = exports.useCreateTimeline = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/store/inputs/constants");
var _default_headers = require("../body/column_headers/default_headers");
var _timeline = require("../../../store/timeline");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _timeline2 = require("../../../../../common/types/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _inputs = require("../../../../common/store/inputs");
var _sourcerer = require("../../../../common/store/sourcerer");
var _model = require("../../../../common/store/sourcerer/model");
var _app = require("../../../../common/store/app");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateTimeline = ({
  timelineId,
  timelineType,
  closeGearMenu
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const defaultDataViewSelector = (0, _react.useMemo)(() => _sourcerer.sourcererSelectors.defaultDataViewSelector(), []);
  const {
    id: dataViewId,
    patternList: selectedPatterns
  } = (0, _use_selector.useDeepEqualSelector)(defaultDataViewSelector);
  const {
    timelineFullScreen,
    setTimelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const globalTimeRange = (0, _use_selector.useDeepEqualSelector)(_inputs.inputsSelectors.globalTimeRangeSelector);
  const createTimeline = (0, _react.useCallback)(({
    id,
    show,
    timeRange: timeRangeParam
  }) => {
    const timerange = timeRangeParam !== null && timeRangeParam !== void 0 ? timeRangeParam : globalTimeRange;
    if (id === _timeline2.TimelineId.active && timelineFullScreen) {
      setTimelineFullScreen(false);
    }
    dispatch(_sourcerer.sourcererActions.setSelectedDataView({
      id: _model.SourcererScopeName.timeline,
      selectedDataViewId: dataViewId,
      selectedPatterns
    }));
    dispatch(_timeline.timelineActions.createTimeline({
      columns: _default_headers.defaultHeaders,
      dataViewId,
      id,
      indexNames: selectedPatterns,
      show,
      timelineType
    }));
    dispatch(_timeline.timelineActions.setTimelineUpdatedAt({
      id: _timeline2.TimelineId.active,
      updated: undefined
    }));
    dispatch(_inputs.inputsActions.addLinkTo([_constants.InputsModelId.global, _constants.InputsModelId.timeline]));
    dispatch(_app.appActions.addNotes({
      notes: []
    }));
    if (timeRangeParam) {
      dispatch(_inputs.inputsActions.removeLinkTo([_constants.InputsModelId.timeline, _constants.InputsModelId.global]));
    }
    if (timerange.kind === 'absolute') {
      dispatch(_inputs.inputsActions.setAbsoluteRangeDatePicker({
        ...timerange,
        id: _constants.InputsModelId.timeline
      }));
    } else if (timerange.kind === 'relative') {
      dispatch(_inputs.inputsActions.setRelativeRangeDatePicker({
        ...timerange,
        id: _constants.InputsModelId.timeline
      }));
    }
  }, [dispatch, globalTimeRange, dataViewId, selectedPatterns, setTimelineFullScreen, timelineFullScreen, timelineType]);
  const handleCreateNewTimeline = (0, _react.useCallback)(options => {
    createTimeline({
      id: timelineId,
      show: true,
      timelineType,
      timeRange: options === null || options === void 0 ? void 0 : options.timeRange
    });
    if (typeof closeGearMenu === 'function') {
      closeGearMenu();
    }
  }, [createTimeline, timelineId, timelineType, closeGearMenu]);
  return handleCreateNewTimeline;
};
exports.useCreateTimeline = useCreateTimeline;
const useCreateTimelineButton = ({
  timelineId,
  timelineType,
  closeGearMenu
}) => {
  const handleCreateNewTimeline = useCreateTimeline({
    timelineId,
    timelineType,
    closeGearMenu
  });
  const getButton = (0, _react.useCallback)(({
    outline,
    title,
    iconType = 'plusInCircle',
    fill = true,
    isDisabled = false
  }) => {
    const buttonProps = {
      iconType,
      onClick: () => handleCreateNewTimeline(),
      fill
    };
    const dataTestSubjPrefix = timelineType === _timeline2.TimelineType.template ? `template-timeline-new` : `timeline-new`;
    const {
      fill: noThanks,
      ...propsWithoutFill
    } = buttonProps;
    return outline ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      "data-test-subj": `${dataTestSubjPrefix}-with-border`
    }, buttonProps), title) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      "data-test-subj": dataTestSubjPrefix,
      color: "text"
    }, propsWithoutFill), title);
  }, [handleCreateNewTimeline, timelineType]);
  return {
    getButton
  };
};
exports.useCreateTimelineButton = useCreateTimelineButton;