"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotesButton = exports.NewTimeline = exports.NOTES_BUTTON_CLASS_NAME = exports.AddToFavoritesButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _timeline = require("../../../../../common/types/timeline");
var _timeline2 = require("../../../store/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_create_timeline = require("./use_create_timeline");
var _defaults = require("../../../store/timeline/defaults");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotesCountBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  margin-left: 5px;
`;
NotesCountBadge.displayName = 'NotesCountBadge';
const AddToFavoritesButtonComponent = ({
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const isFavorite = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).isFavorite;
  });
  const status = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline2;
    return ((_getTimeline2 = getTimeline(state, timelineId)) !== null && _getTimeline2 !== void 0 ? _getTimeline2 : _defaults.timelineDefaults).status;
  });
  const disableFavoriteButton = status === _timeline.TimelineStatus.immutable;
  const handleClick = (0, _react.useCallback)(() => dispatch(_timeline2.timelineActions.updateIsFavorite({
    id: timelineId,
    isFavorite: !isFavorite
  })), [dispatch, timelineId, isFavorite]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isSelected: isFavorite,
    fill: isFavorite,
    iconType: isFavorite ? 'starFilled' : 'starEmpty',
    onClick: handleClick,
    "data-test-subj": `timeline-favorite-${isFavorite ? 'filled' : 'empty'}-star`,
    disabled: disableFavoriteButton
  }, isFavorite ? i18n.REMOVE_FROM_FAVORITES : i18n.ADD_TO_FAVORITES);
};
AddToFavoritesButtonComponent.displayName = 'AddToFavoritesButtonComponent';
const AddToFavoritesButton = /*#__PURE__*/_react.default.memo(AddToFavoritesButtonComponent);
exports.AddToFavoritesButton = AddToFavoritesButton;
const NewTimeline = /*#__PURE__*/_react.default.memo(({
  closeGearMenu,
  outline = false,
  timelineId,
  title = i18n.NEW_TIMELINE
}) => {
  const {
    getButton
  } = (0, _use_create_timeline.useCreateTimelineButton)({
    timelineId,
    timelineType: _timeline.TimelineType.default,
    closeGearMenu
  });
  const button = getButton({
    outline,
    title
  });
  return button;
});
exports.NewTimeline = NewTimeline;
NewTimeline.displayName = 'NewTimeline';
const NOTES_BUTTON_CLASS_NAME = 'notes-button';
exports.NOTES_BUTTON_CLASS_NAME = NOTES_BUTTON_CLASS_NAME;
const SmallNotesButton = /*#__PURE__*/_react.default.memo(({
  ariaLabel = i18n.NOTES,
  isDisabled,
  toggleShowNotes,
  timelineType
}) => {
  const isTemplate = timelineType === _timeline.TimelineType.template;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": ariaLabel,
    className: NOTES_BUTTON_CLASS_NAME,
    "data-test-subj": "timeline-notes-button-small",
    disabled: isDisabled,
    iconType: "editorComment",
    onClick: toggleShowNotes,
    size: "s",
    isDisabled: isTemplate
  });
});
SmallNotesButton.displayName = 'SmallNotesButton';
const NotesButton = /*#__PURE__*/_react.default.memo(({
  ariaLabel,
  isDisabled,
  showNotes,
  timelineType,
  toggleShowNotes,
  toolTip
}) => showNotes ? /*#__PURE__*/_react.default.createElement(SmallNotesButton, {
  ariaLabel: ariaLabel,
  isDisabled: isDisabled,
  toggleShowNotes: toggleShowNotes,
  timelineType: timelineType
}) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: toolTip || '',
  "data-test-subj": "timeline-notes-tool-tip"
}, /*#__PURE__*/_react.default.createElement(SmallNotesButton, {
  ariaLabel: ariaLabel,
  isDisabled: isDisabled,
  toggleShowNotes: toggleShowNotes,
  timelineType: timelineType
})));
exports.NotesButton = NotesButton;
NotesButton.displayName = 'NotesButton';