"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _sourcerer = require("../../../../common/containers/sourcerer");
var _model = require("../../../../common/store/sourcerer/model");
var _timeline = require("../../../store/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _timeline2 = require("../../../../../common/types/timeline");
var _app = require("../../../../common/store/app");
var _add_note = require("../../notes/add_note");
var _translations = require("../../notes/translations");
var _translations2 = require("../translations");
var _note_previews = require("../../open_timeline/note_previews");
var _selectors = require("./selectors");
var _side_panel = require("../../side_panel");
var _selectors2 = require("../tabs_content/selectors");
var _scroll_to_top = require("../../../../common/components/scroll_to_top");
var _user_privileges = require("../../../../common/components/user_privileges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FullWidthFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  width: 100%;
  margin: 0;
  overflow: hidden;
`;
const ScrollableFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow-x: hidden;
  overflow-y: auto;
`;
const VerticalRule = _styledComponents.default.div`
  width: 2px;
  height: 100%;
  background: ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
const StyledPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  border: 0;
  box-shadow: none;
`;
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  flex: 0;
`;
const Username = (0, _styledComponents.default)(_eui.EuiText)`
  font-weight: bold;
`;
const UsernameWithAvatarComponent = ({
  username
}) => /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
  gutterSize: "s",
  responsive: false,
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
  "data-test-subj": "avatar",
  name: username,
  size: "l"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(Username, null, username)));
const UsernameWithAvatar = /*#__PURE__*/_react.default.memo(UsernameWithAvatarComponent);
const ParticipantsComponent = ({
  users
}) => {
  const List = (0, _react.useMemo)(() => users.map(user => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: user.updatedBy === null ? undefined : user.updatedBy
  }, /*#__PURE__*/_react.default.createElement(UsernameWithAvatar, {
    key: user.updatedBy === null ? undefined : user.updatedBy,
    username: String(user.updatedBy)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), [users]);
  if (!users.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _translations2.PARTICIPANTS)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), List);
};
ParticipantsComponent.displayName = 'ParticipantsComponent';
const Participants = /*#__PURE__*/_react.default.memo(ParticipantsComponent);
const NotesTabContentComponent = ({
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    kibanaSecuritySolutionsPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const getScrollToTop = (0, _react.useMemo)(() => (0, _selectors2.getScrollToTopSelector)(), []);
  const scrollToTop = (0, _use_selector.useShallowEqualSelector)(state => getScrollToTop(state, timelineId));
  (0, _scroll_to_top.useScrollToTop)('#scrollableNotes', !!scrollToTop);
  const getTimelineNotes = (0, _react.useMemo)(() => (0, _selectors.getTimelineNoteSelector)(), []);
  const {
    createdBy,
    expandedDetail,
    eventIdToNoteIds,
    noteIds,
    status: timelineStatus
  } = (0, _use_selector.useDeepEqualSelector)(state => getTimelineNotes(state, timelineId));
  const {
    browserFields,
    runtimeMappings
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const getNotesAsCommentsList = (0, _react.useMemo)(() => _app.appSelectors.selectNotesAsCommentsListSelector(), []);
  const [newNote, setNewNote] = (0, _react.useState)('');
  const isImmutable = timelineStatus === _timeline2.TimelineStatus.immutable;
  const appNotes = (0, _use_selector.useDeepEqualSelector)(getNotesAsCommentsList);
  const allTimelineNoteIds = (0, _react.useMemo)(() => {
    const eventNoteIds = Object.values(eventIdToNoteIds).reduce((acc, v) => [...acc, ...v], []);
    return [...noteIds, ...eventNoteIds];
  }, [noteIds, eventIdToNoteIds]);
  const notes = (0, _react.useMemo)(() => appNotes.filter(appNote => {
    var _appNote$noteId;
    return allTimelineNoteIds.includes((_appNote$noteId = appNote === null || appNote === void 0 ? void 0 : appNote.noteId) !== null && _appNote$noteId !== void 0 ? _appNote$noteId : '-1');
  }), [appNotes, allTimelineNoteIds]);

  // filter for savedObjectId to make sure we don't display `elastic` user while saving the note
  const participants = (0, _react.useMemo)(() => (0, _fp.uniqBy)('updatedBy', (0, _fp.filter)('savedObjectId', notes)), [notes]);
  const associateNote = (0, _react.useCallback)(noteId => dispatch(_timeline.timelineActions.addNote({
    id: timelineId,
    noteId
  })), [dispatch, timelineId]);
  const handleOnPanelClosed = (0, _react.useCallback)(() => {
    dispatch(_timeline.timelineActions.toggleDetailPanel({
      tabType: _timeline2.TimelineTabs.notes,
      id: timelineId
    }));
  }, [dispatch, timelineId]);
  const DetailsPanelContent = (0, _react.useMemo)(() => {
    var _expandedDetail$Timel;
    return (_expandedDetail$Timel = expandedDetail[_timeline2.TimelineTabs.notes]) !== null && _expandedDetail$Timel !== void 0 && _expandedDetail$Timel.panelView ? /*#__PURE__*/_react.default.createElement(_side_panel.DetailsPanel, {
      browserFields: browserFields,
      handleOnPanelClosed: handleOnPanelClosed,
      runtimeMappings: runtimeMappings,
      tabType: _timeline2.TimelineTabs.notes,
      scopeId: timelineId
    }) : null;
  }, [browserFields, expandedDetail, handleOnPanelClosed, runtimeMappings, timelineId]);
  const SidebarContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, createdBy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _translations.CREATED_BY)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(UsernameWithAvatar, {
    username: createdBy
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(Participants, {
    users: participants
  })), [createdBy, participants]);
  return /*#__PURE__*/_react.default.createElement(FullWidthFlexGroup, null, /*#__PURE__*/_react.default.createElement(ScrollableFlexItem, {
    grow: 2,
    id: "scrollableNotes"
  }, /*#__PURE__*/_react.default.createElement(StyledPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, _translations.NOTES)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_note_previews.NotePreviews, {
    eventIdToNoteIds: eventIdToNoteIds,
    notes: notes,
    timelineId: timelineId,
    showTimelineDescription: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !isImmutable && kibanaSecuritySolutionsPrivileges.crud === true && /*#__PURE__*/_react.default.createElement(_add_note.AddNote, {
    associateNote: associateNote,
    newNote: newNote,
    updateNewNote: setNewNote,
    autoFocusDisabled: !!scrollToTop
  }))), /*#__PURE__*/_react.default.createElement(VerticalRule, null), /*#__PURE__*/_react.default.createElement(ScrollableFlexItem, {
    grow: 1
  }, DetailsPanelContent !== null && DetailsPanelContent !== void 0 ? DetailsPanelContent : SidebarContent));
};
NotesTabContentComponent.displayName = 'NotesTabContentComponent';
const NotesTabContent = /*#__PURE__*/_react.default.memo(NotesTabContentComponent);

// eslint-disable-next-line import/no-default-export
exports.default = NotesTabContent;
module.exports = exports.default;