"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProviderActions = exports.ProviderItemActions = exports.FILTER_FOR_FIELD_PRESENT_CLASS_NAME = exports.EXCLUDE_CLASS_NAME = exports.ENABLE_CLASS_NAME = exports.EDIT_CLASS_NAME = exports.DELETE_CLASS_NAME = exports.CONVERT_TO_FIELD_CLASS_NAME = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../../common/types/timeline");
var _data_provider = require("./data_provider");
var _edit_data_provider = require("../../edit_data_provider");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDIT_CLASS_NAME = 'edit-data-provider';
exports.EDIT_CLASS_NAME = EDIT_CLASS_NAME;
const EXCLUDE_CLASS_NAME = 'exclude-data-provider';
exports.EXCLUDE_CLASS_NAME = EXCLUDE_CLASS_NAME;
const ENABLE_CLASS_NAME = 'enable-data-provider';
exports.ENABLE_CLASS_NAME = ENABLE_CLASS_NAME;
const FILTER_FOR_FIELD_PRESENT_CLASS_NAME = 'filter-for-field-present-data-provider';
exports.FILTER_FOR_FIELD_PRESENT_CLASS_NAME = FILTER_FOR_FIELD_PRESENT_CLASS_NAME;
const CONVERT_TO_FIELD_CLASS_NAME = 'convert-to-field-data-provider';
exports.CONVERT_TO_FIELD_CLASS_NAME = CONVERT_TO_FIELD_CLASS_NAME;
const DELETE_CLASS_NAME = 'delete-data-provider';
exports.DELETE_CLASS_NAME = DELETE_CLASS_NAME;
const MyEuiPopover = (0, _styledComponents.default)(_eui.EuiPopover)`
  height: 100%;
  user-select: none;
`;
MyEuiPopover.displayName = 'MyEuiPopover';
const getProviderActions = ({
  andProviderId,
  browserFields,
  deleteItem,
  field,
  isEnabled,
  isExcluded,
  isLoading,
  operator,
  onDataProviderEdited,
  onFilterForFieldPresent,
  providerId,
  timelineId,
  timelineType,
  toggleEnabled,
  toggleExcluded,
  toggleType,
  type,
  value
}) => [{
  id: 0,
  items: [{
    className: EDIT_CLASS_NAME,
    disabled: isLoading,
    icon: 'pencil',
    name: i18n.EDIT_MENU_ITEM,
    panel: 1
  }, {
    className: EXCLUDE_CLASS_NAME,
    disabled: isLoading,
    icon: `${isExcluded ? 'plusInCircle' : 'minusInCircle'}`,
    name: isExcluded ? i18n.INCLUDE_DATA_PROVIDER : i18n.EXCLUDE_DATA_PROVIDER,
    onClick: toggleExcluded
  }, {
    className: ENABLE_CLASS_NAME,
    disabled: isLoading,
    icon: `${isEnabled ? 'eyeClosed' : 'eye'}`,
    name: isEnabled ? i18n.TEMPORARILY_DISABLE_DATA_PROVIDER : i18n.RE_ENABLE_DATA_PROVIDER,
    onClick: toggleEnabled
  }, {
    className: FILTER_FOR_FIELD_PRESENT_CLASS_NAME,
    disabled: isLoading,
    icon: 'logstashFilter',
    name: i18n.FILTER_FOR_FIELD_PRESENT,
    onClick: onFilterForFieldPresent
  }, timelineType === _timeline.TimelineType.template ? {
    className: CONVERT_TO_FIELD_CLASS_NAME,
    disabled: isLoading || operator === _data_provider.IS_ONE_OF_OPERATOR,
    icon: 'visText',
    name: type === _data_provider.DataProviderType.template ? i18n.CONVERT_TO_FIELD : i18n.CONVERT_TO_TEMPLATE_FIELD,
    onClick: toggleType
  } : {
    name: null
  }, {
    className: DELETE_CLASS_NAME,
    disabled: isLoading,
    icon: 'trash',
    name: i18n.DELETE_DATA_PROVIDER,
    onClick: deleteItem
  }].filter(item => item.name != null)
}, {
  content: browserFields != null && timelineId != null && onDataProviderEdited != null ? /*#__PURE__*/_react.default.createElement(_edit_data_provider.StatefulEditDataProvider, {
    andProviderId: andProviderId,
    browserFields: browserFields,
    field: field,
    isExcluded: isExcluded,
    onDataProviderEdited: onDataProviderEdited,
    operator: operator,
    providerId: providerId,
    timelineId: timelineId,
    value: value,
    type: type
  }) : null,
  id: 1,
  title: i18n.EDIT_TITLE,
  width: 400
}];
exports.getProviderActions = getProviderActions;
class ProviderItemActions extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "onDataProviderEdited", ({
      andProviderId,
      excluded,
      field,
      id,
      operator,
      providerId,
      value,
      type
    }) => {
      if (this.props.onDataProviderEdited != null) {
        this.props.onDataProviderEdited({
          andProviderId,
          excluded,
          field,
          id,
          operator,
          providerId,
          value,
          type
        });
      }
      this.props.closePopover();
    });
    (0, _defineProperty2.default)(this, "onFilterForFieldPresent", () => {
      const {
        andProviderId,
        field,
        timelineId,
        providerId,
        value,
        type
      } = this.props;
      if (this.props.onDataProviderEdited != null) {
        this.props.onDataProviderEdited({
          andProviderId,
          excluded: false,
          field,
          id: `${timelineId}`,
          operator: _data_provider.EXISTS_OPERATOR,
          providerId,
          value,
          type
        });
      }
      this.props.closePopover();
    });
  }
  render() {
    const {
      andProviderId,
      browserFields,
      button,
      closePopover,
      deleteProvider,
      field,
      isEnabled,
      isExcluded,
      isLoading,
      isOpen,
      operator,
      providerId,
      timelineId,
      timelineType,
      toggleEnabledProvider,
      toggleExcludedProvider,
      toggleTypeProvider,
      value,
      type
    } = this.props;
    const panelTree = getProviderActions({
      andProviderId,
      browserFields,
      deleteItem: deleteProvider,
      field,
      isEnabled,
      isExcluded,
      isLoading,
      onDataProviderEdited: this.onDataProviderEdited,
      onFilterForFieldPresent: this.onFilterForFieldPresent,
      operator,
      providerId,
      timelineId,
      timelineType,
      toggleEnabled: toggleEnabledProvider,
      toggleExcluded: toggleExcludedProvider,
      toggleType: toggleTypeProvider,
      value,
      type
    });
    return /*#__PURE__*/_react.default.createElement(MyEuiPopover, {
      id: `popoverFor_${providerId}-${field}-${value}`,
      isOpen: isOpen,
      closePopover: closePopover,
      button: button,
      anchorPosition: "downCenter",
      panelPaddingSize: "none",
      ownFocus: true
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        userSelect: 'none'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: 0,
      panels: panelTree,
      "data-test-subj": "providerActions"
    })));
  }
}
exports.ProviderItemActions = ProviderItemActions;