"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TCP = exports.SOURCE = exports.SHOW_ALL_INDICATOR_MATCHES = exports.NON_EXISTENT = exports.LINK_ELASTIC_ENDPOINT_SECURITY = exports.IN = exports.FROM_ITS_ORIGINAL_PATH = exports.DESTINATION = exports.ALL_INDICATOR_MATCHES_MODAL_HEADER = exports.ALL_INDICATOR_MATCHES_MODAL_CLOSE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TCP = _i18n.i18n.translate('xpack.securitySolution.timeline.tcp', {
  defaultMessage: 'TCP'
});
exports.TCP = TCP;
const DESTINATION = _i18n.i18n.translate('xpack.securitySolution.timeline.destination', {
  defaultMessage: 'Destination'
});
exports.DESTINATION = DESTINATION;
const FROM_ITS_ORIGINAL_PATH = _i18n.i18n.translate('xpack.securitySolution.timeline.file.fromOriginalPathDescription', {
  defaultMessage: 'from its original path'
});
exports.FROM_ITS_ORIGINAL_PATH = FROM_ITS_ORIGINAL_PATH;
const SOURCE = _i18n.i18n.translate('xpack.securitySolution.timeline.source', {
  defaultMessage: 'Source'
});
exports.SOURCE = SOURCE;
const IN = _i18n.i18n.translate('xpack.securitySolution.auditd.inDescription', {
  defaultMessage: 'in'
});
exports.IN = IN;
const NON_EXISTENT = _i18n.i18n.translate('xpack.securitySolution.auditd.nonExistentDescription', {
  defaultMessage: 'an unknown process'
});
exports.NON_EXISTENT = NON_EXISTENT;
const LINK_ELASTIC_ENDPOINT_SECURITY = _i18n.i18n.translate('xpack.securitySolution.event.module.linkToElasticEndpointSecurityDescription', {
  defaultMessage: 'Open in Endpoint Security'
});
exports.LINK_ELASTIC_ENDPOINT_SECURITY = LINK_ELASTIC_ENDPOINT_SECURITY;
const SHOW_ALL_INDICATOR_MATCHES = count => _i18n.i18n.translate('xpack.securitySolution.event.summary.threat_indicator.showMatches', {
  values: {
    count
  },
  defaultMessage: 'Show all {count} indicator match alerts'
});
exports.SHOW_ALL_INDICATOR_MATCHES = SHOW_ALL_INDICATOR_MATCHES;
const ALL_INDICATOR_MATCHES_MODAL_HEADER = _i18n.i18n.translate('xpack.securitySolution.event.summary.threat_indicator.modal.allMatches', {
  defaultMessage: 'All Indicator Matches'
});
exports.ALL_INDICATOR_MATCHES_MODAL_HEADER = ALL_INDICATOR_MATCHES_MODAL_HEADER;
const ALL_INDICATOR_MATCHES_MODAL_CLOSE = _i18n.i18n.translate('xpack.securitySolution.event.summary.threat_indicator.modal.close', {
  defaultMessage: 'Close'
});
exports.ALL_INDICATOR_MATCHES_MODAL_CLOSE = ALL_INDICATOR_MATCHES_MODAL_CLOSE;