"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuricataRefs = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _suricata_links = require("./suricata_links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  display: inline;
`;
LinkEuiFlexItem.displayName = 'LinkEuiFlexItem';
const SuricataRefs = /*#__PURE__*/_react.default.memo(({
  signatureId
}) => {
  const [linksFromSignature, setLinksFromSignature] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    async function getLinks() {
      if (signatureId != null) {
        try {
          const links = await (0, _suricata_links.getLinksFromSignature)(signatureId);
          if (isSubscribed && links != null) {
            setLinksFromSignature(links);
          }
        } catch (exc) {
          setLinksFromSignature(undefined);
        }
      } else if (isSubscribed) {
        setLinksFromSignature(undefined);
      }
    }
    getLinks();
    return () => {
      isSubscribed = false;
    };
  }, [signatureId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "suricataRefs",
    gutterSize: "none",
    justifyContent: "center",
    wrap: true
  }, linksFromSignature && linksFromSignature.map(link => /*#__PURE__*/_react.default.createElement(LinkEuiFlexItem, {
    key: link,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: link,
    color: "subdued",
    target: "_blank"
  }, link))));
});
exports.SuricataRefs = SuricataRefs;
SuricataRefs.displayName = 'SuricataRefs';